<?php

namespace Pcm\EnumType;

/**
 * This class stands for RoadType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmRoadType
{
    /**
     * Constant for value 'InterStateRural'
     * @return string 'InterStateRural'
     */
    const VALUE_INTER_STATE_RURAL = 'InterStateRural';
    /**
     * Constant for value 'DividedRural'
     * @return string 'DividedRural'
     */
    const VALUE_DIVIDED_RURAL = 'DividedRural';
    /**
     * Constant for value 'PrimaryRural'
     * @return string 'PrimaryRural'
     */
    const VALUE_PRIMARY_RURAL = 'PrimaryRural';
    /**
     * Constant for value 'FerriesRural'
     * @return string 'FerriesRural'
     */
    const VALUE_FERRIES_RURAL = 'FerriesRural';
    /**
     * Constant for value 'SecondaryRural'
     * @return string 'SecondaryRural'
     */
    const VALUE_SECONDARY_RURAL = 'SecondaryRural';
    /**
     * Constant for value 'RampRural'
     * @return string 'RampRural'
     */
    const VALUE_RAMP_RURAL = 'RampRural';
    /**
     * Constant for value 'LocalRural'
     * @return string 'LocalRural'
     */
    const VALUE_LOCAL_RURAL = 'LocalRural';
    /**
     * Constant for value 'InterStateUrban'
     * @return string 'InterStateUrban'
     */
    const VALUE_INTER_STATE_URBAN = 'InterStateUrban';
    /**
     * Constant for value 'DividedUrban'
     * @return string 'DividedUrban'
     */
    const VALUE_DIVIDED_URBAN = 'DividedUrban';
    /**
     * Constant for value 'PrimaryUrban'
     * @return string 'PrimaryUrban'
     */
    const VALUE_PRIMARY_URBAN = 'PrimaryUrban';
    /**
     * Constant for value 'FerriesUrban'
     * @return string 'FerriesUrban'
     */
    const VALUE_FERRIES_URBAN = 'FerriesUrban';
    /**
     * Constant for value 'SecondaryUrban'
     * @return string 'SecondaryUrban'
     */
    const VALUE_SECONDARY_URBAN = 'SecondaryUrban';
    /**
     * Constant for value 'RampUrban'
     * @return string 'RampUrban'
     */
    const VALUE_RAMP_URBAN = 'RampUrban';
    /**
     * Constant for value 'LocalUrban'
     * @return string 'LocalUrban'
     */
    const VALUE_LOCAL_URBAN = 'LocalUrban';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTER_STATE_RURAL
     * @uses self::VALUE_DIVIDED_RURAL
     * @uses self::VALUE_PRIMARY_RURAL
     * @uses self::VALUE_FERRIES_RURAL
     * @uses self::VALUE_SECONDARY_RURAL
     * @uses self::VALUE_RAMP_RURAL
     * @uses self::VALUE_LOCAL_RURAL
     * @uses self::VALUE_INTER_STATE_URBAN
     * @uses self::VALUE_DIVIDED_URBAN
     * @uses self::VALUE_PRIMARY_URBAN
     * @uses self::VALUE_FERRIES_URBAN
     * @uses self::VALUE_SECONDARY_URBAN
     * @uses self::VALUE_RAMP_URBAN
     * @uses self::VALUE_LOCAL_URBAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTER_STATE_RURAL,
            self::VALUE_DIVIDED_RURAL,
            self::VALUE_PRIMARY_RURAL,
            self::VALUE_FERRIES_RURAL,
            self::VALUE_SECONDARY_RURAL,
            self::VALUE_RAMP_RURAL,
            self::VALUE_LOCAL_RURAL,
            self::VALUE_INTER_STATE_URBAN,
            self::VALUE_DIVIDED_URBAN,
            self::VALUE_PRIMARY_URBAN,
            self::VALUE_FERRIES_URBAN,
            self::VALUE_SECONDARY_URBAN,
            self::VALUE_RAMP_URBAN,
            self::VALUE_LOCAL_URBAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
