<?php

namespace Pcm\EnumType;

/**
 * This class stands for PointSpread EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PointSpread
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPointSpread
{
    /**
     * Constant for value 'Most'
     * @return string 'Most'
     */
    const VALUE_MOST = 'Most';
    /**
     * Constant for value 'Average'
     * @return string 'Average'
     */
    const VALUE_AVERAGE = 'Average';
    /**
     * Constant for value 'Cluster'
     * @return string 'Cluster'
     */
    const VALUE_CLUSTER = 'Cluster';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MOST
     * @uses self::VALUE_AVERAGE
     * @uses self::VALUE_CLUSTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MOST,
            self::VALUE_AVERAGE,
            self::VALUE_CLUSTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
