<?php

namespace Pcm\EnumType;

/**
 * This class stands for PointGroupDensity EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PointGroupDensity
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPointGroupDensity
{
    /**
     * Constant for value 'Few'
     * @return string 'Few'
     */
    const VALUE_FEW = 'Few';
    /**
     * Constant for value 'Average'
     * @return string 'Average'
     */
    const VALUE_AVERAGE = 'Average';
    /**
     * Constant for value 'Most'
     * @return string 'Most'
     */
    const VALUE_MOST = 'Most';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FEW
     * @uses self::VALUE_AVERAGE
     * @uses self::VALUE_MOST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FEW,
            self::VALUE_AVERAGE,
            self::VALUE_MOST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
