<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMapGroupInfo ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMapGroupInfo
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfMapGroupInfo extends AbstractStructArrayBase
{
    /**
     * The MapGroupInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmMapGroupInfo[]
     */
    public $MapGroupInfo;
    /**
     * Constructor method for ArrayOfMapGroupInfo
     * @uses PcmArrayOfMapGroupInfo::setMapGroupInfo()
     * @param \Pcm\StructType\PcmMapGroupInfo[] $mapGroupInfo
     */
    public function __construct(array $mapGroupInfo = array())
    {
        $this
            ->setMapGroupInfo($mapGroupInfo);
    }
    /**
     * Get MapGroupInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmMapGroupInfo[]|null
     */
    public function getMapGroupInfo()
    {
        return isset($this->MapGroupInfo) ? $this->MapGroupInfo : null;
    }
    /**
     * Set MapGroupInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmMapGroupInfo[] $mapGroupInfo
     * @return \Pcm\ArrayType\PcmArrayOfMapGroupInfo
     */
    public function setMapGroupInfo(array $mapGroupInfo = array())
    {
        foreach ($mapGroupInfo as $arrayOfMapGroupInfoMapGroupInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfMapGroupInfoMapGroupInfoItem instanceof \Pcm\StructType\PcmMapGroupInfo) {
                throw new \InvalidArgumentException(sprintf('The MapGroupInfo property can only contain items of \Pcm\StructType\PcmMapGroupInfo, "%s" given', is_object($arrayOfMapGroupInfoMapGroupInfoItem) ? get_class($arrayOfMapGroupInfoMapGroupInfoItem) : gettype($arrayOfMapGroupInfoMapGroupInfoItem)), __LINE__);
            }
        }
        if (is_null($mapGroupInfo) || (is_array($mapGroupInfo) && empty($mapGroupInfo))) {
            unset($this->MapGroupInfo);
        } else {
            $this->MapGroupInfo = $mapGroupInfo;
        }
        return $this;
    }
    /**
     * Add item to MapGroupInfo value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmMapGroupInfo $item
     * @return \Pcm\ArrayType\PcmArrayOfMapGroupInfo
     */
    public function addToMapGroupInfo(\Pcm\StructType\PcmMapGroupInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmMapGroupInfo) {
            throw new \InvalidArgumentException(sprintf('The MapGroupInfo property can only contain items of \Pcm\StructType\PcmMapGroupInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MapGroupInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmMapGroupInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmMapGroupInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmMapGroupInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmMapGroupInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmMapGroupInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MapGroupInfo
     */
    public function getAttributeName()
    {
        return 'MapGroupInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfMapGroupInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
