<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrayOfint ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfArrayOfint
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfArrayOfint extends AbstractStructArrayBase
{
    /**
     * The ArrayOfint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfint[]
     */
    public $ArrayOfint;
    /**
     * Constructor method for ArrayOfArrayOfint
     * @uses PcmArrayOfArrayOfint::setArrayOfint()
     * @param \Pcm\ArrayType\PcmArrayOfint[] $arrayOfint
     */
    public function __construct(array $arrayOfint = array())
    {
        $this
            ->setArrayOfint($arrayOfint);
    }
    /**
     * Get ArrayOfint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfint[]|null
     */
    public function getArrayOfint()
    {
        return isset($this->ArrayOfint) ? $this->ArrayOfint : null;
    }
    /**
     * Set ArrayOfint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\ArrayType\PcmArrayOfint[] $arrayOfint
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfint
     */
    public function setArrayOfint(array $arrayOfint = array())
    {
        foreach ($arrayOfint as $arrayOfArrayOfintArrayOfintItem) {
            // validation for constraint: itemType
            if (!$arrayOfArrayOfintArrayOfintItem instanceof \Pcm\ArrayType\PcmArrayOfint) {
                throw new \InvalidArgumentException(sprintf('The ArrayOfint property can only contain items of \Pcm\ArrayType\PcmArrayOfint, "%s" given', is_object($arrayOfArrayOfintArrayOfintItem) ? get_class($arrayOfArrayOfintArrayOfintItem) : gettype($arrayOfArrayOfintArrayOfintItem)), __LINE__);
            }
        }
        if (is_null($arrayOfint) || (is_array($arrayOfint) && empty($arrayOfint))) {
            unset($this->ArrayOfint);
        } else {
            $this->ArrayOfint = $arrayOfint;
        }
        return $this;
    }
    /**
     * Add item to ArrayOfint value
     * @throws \InvalidArgumentException
     * @param \Pcm\ArrayType\PcmArrayOfint $item
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfint
     */
    public function addToArrayOfint(\Pcm\ArrayType\PcmArrayOfint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\ArrayType\PcmArrayOfint) {
            throw new \InvalidArgumentException(sprintf('The ArrayOfint property can only contain items of \Pcm\ArrayType\PcmArrayOfint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArrayOfint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArrayOfint
     */
    public function getAttributeName()
    {
        return 'ArrayOfint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
