<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetRoadSpeedsRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SetRoadSpeedsRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmSetRoadSpeedsRequestBody extends AbstractStructBase
{
    /**
     * The RoadSpeeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfRoadSpeed
     */
    public $RoadSpeeds;
    /**
     * The AbbreviationFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AbbreviationFormat;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vehicle;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * Constructor method for SetRoadSpeedsRequestBody
     * @uses PcmSetRoadSpeedsRequestBody::setRoadSpeeds()
     * @uses PcmSetRoadSpeedsRequestBody::setAbbreviationFormat()
     * @uses PcmSetRoadSpeedsRequestBody::setVehicle()
     * @uses PcmSetRoadSpeedsRequestBody::setRegion()
     * @param \Pcm\ArrayType\PcmArrayOfRoadSpeed $roadSpeeds
     * @param string $abbreviationFormat
     * @param string $vehicle
     * @param string $region
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfRoadSpeed $roadSpeeds = null, $abbreviationFormat = null, $vehicle = null, $region = null)
    {
        $this
            ->setRoadSpeeds($roadSpeeds)
            ->setAbbreviationFormat($abbreviationFormat)
            ->setVehicle($vehicle)
            ->setRegion($region);
    }
    /**
     * Get RoadSpeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfRoadSpeed|null
     */
    public function getRoadSpeeds()
    {
        return isset($this->RoadSpeeds) ? $this->RoadSpeeds : null;
    }
    /**
     * Set RoadSpeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfRoadSpeed $roadSpeeds
     * @return \Pcm\StructType\PcmSetRoadSpeedsRequestBody
     */
    public function setRoadSpeeds(\Pcm\ArrayType\PcmArrayOfRoadSpeed $roadSpeeds = null)
    {
        if (is_null($roadSpeeds) || (is_array($roadSpeeds) && empty($roadSpeeds))) {
            unset($this->RoadSpeeds);
        } else {
            $this->RoadSpeeds = $roadSpeeds;
        }
        return $this;
    }
    /**
     * Get AbbreviationFormat value
     * @return string|null
     */
    public function getAbbreviationFormat()
    {
        return $this->AbbreviationFormat;
    }
    /**
     * Set AbbreviationFormat value
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abbreviationFormat
     * @return \Pcm\StructType\PcmSetRoadSpeedsRequestBody
     */
    public function setAbbreviationFormat($abbreviationFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid($abbreviationFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $abbreviationFormat, implode(', ', \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues())), __LINE__);
        }
        $this->AbbreviationFormat = $abbreviationFormat;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return string|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @uses \Pcm\EnumType\PcmVehicleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicle
     * @return \Pcm\StructType\PcmSetRoadSpeedsRequestBody
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVehicleType::valueIsValid($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicle, implode(', ', \Pcm\EnumType\PcmVehicleType::getValidValues())), __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmSetRoadSpeedsRequestBody
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmSetRoadSpeedsRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
