<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutePointsRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoutePointsRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoutePointsRequestBody extends AbstractStructBase
{
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfExtendedRoute
     */
    public $Routes;
    /**
     * The ReduceResponsePoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReduceResponsePoints;
    /**
     * The IncludePLIDs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePLIDs;
    /**
     * Constructor method for RoutePointsRequestBody
     * @uses PcmRoutePointsRequestBody::setRoutes()
     * @uses PcmRoutePointsRequestBody::setReduceResponsePoints()
     * @uses PcmRoutePointsRequestBody::setIncludePLIDs()
     * @param \Pcm\ArrayType\PcmArrayOfExtendedRoute $routes
     * @param bool $reduceResponsePoints
     * @param bool $includePLIDs
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfExtendedRoute $routes = null, $reduceResponsePoints = null, $includePLIDs = null)
    {
        $this
            ->setRoutes($routes)
            ->setReduceResponsePoints($reduceResponsePoints)
            ->setIncludePLIDs($includePLIDs);
    }
    /**
     * Get Routes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfExtendedRoute|null
     */
    public function getRoutes()
    {
        return isset($this->Routes) ? $this->Routes : null;
    }
    /**
     * Set Routes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfExtendedRoute $routes
     * @return \Pcm\StructType\PcmRoutePointsRequestBody
     */
    public function setRoutes(\Pcm\ArrayType\PcmArrayOfExtendedRoute $routes = null)
    {
        if (is_null($routes) || (is_array($routes) && empty($routes))) {
            unset($this->Routes);
        } else {
            $this->Routes = $routes;
        }
        return $this;
    }
    /**
     * Get ReduceResponsePoints value
     * @return bool|null
     */
    public function getReduceResponsePoints()
    {
        return $this->ReduceResponsePoints;
    }
    /**
     * Set ReduceResponsePoints value
     * @param bool $reduceResponsePoints
     * @return \Pcm\StructType\PcmRoutePointsRequestBody
     */
    public function setReduceResponsePoints($reduceResponsePoints = null)
    {
        // validation for constraint: boolean
        if (!is_null($reduceResponsePoints) && !is_bool($reduceResponsePoints)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reduceResponsePoints)), __LINE__);
        }
        $this->ReduceResponsePoints = $reduceResponsePoints;
        return $this;
    }
    /**
     * Get IncludePLIDs value
     * @return bool|null
     */
    public function getIncludePLIDs()
    {
        return $this->IncludePLIDs;
    }
    /**
     * Set IncludePLIDs value
     * @param bool $includePLIDs
     * @return \Pcm\StructType\PcmRoutePointsRequestBody
     */
    public function setIncludePLIDs($includePLIDs = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePLIDs) && !is_bool($includePLIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includePLIDs)), __LINE__);
        }
        $this->IncludePLIDs = $includePLIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoutePointsRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
