<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Route StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Route
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoute extends AbstractStructBase
{
    /**
     * The RouteId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteId;
    /**
     * The Stops
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfStopLocation
     */
    public $Stops;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteOptions
     */
    public $Options;
    /**
     * The FuelOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmFuelOptions
     */
    public $FuelOptions;
    /**
     * Constructor method for Route
     * @uses PcmRoute::setRouteId()
     * @uses PcmRoute::setStops()
     * @uses PcmRoute::setOptions()
     * @uses PcmRoute::setFuelOptions()
     * @param string $routeId
     * @param \Pcm\ArrayType\PcmArrayOfStopLocation $stops
     * @param \Pcm\StructType\PcmRouteOptions $options
     * @param \Pcm\StructType\PcmFuelOptions $fuelOptions
     */
    public function __construct($routeId = null, \Pcm\ArrayType\PcmArrayOfStopLocation $stops = null, \Pcm\StructType\PcmRouteOptions $options = null, \Pcm\StructType\PcmFuelOptions $fuelOptions = null)
    {
        $this
            ->setRouteId($routeId)
            ->setStops($stops)
            ->setOptions($options)
            ->setFuelOptions($fuelOptions);
    }
    /**
     * Get RouteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteId()
    {
        return isset($this->RouteId) ? $this->RouteId : null;
    }
    /**
     * Set RouteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeId
     * @return \Pcm\StructType\PcmRoute
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: string
        if (!is_null($routeId) && !is_string($routeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeId)), __LINE__);
        }
        if (is_null($routeId) || (is_array($routeId) && empty($routeId))) {
            unset($this->RouteId);
        } else {
            $this->RouteId = $routeId;
        }
        return $this;
    }
    /**
     * Get Stops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfStopLocation|null
     */
    public function getStops()
    {
        return isset($this->Stops) ? $this->Stops : null;
    }
    /**
     * Set Stops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfStopLocation $stops
     * @return \Pcm\StructType\PcmRoute
     */
    public function setStops(\Pcm\ArrayType\PcmArrayOfStopLocation $stops = null)
    {
        if (is_null($stops) || (is_array($stops) && empty($stops))) {
            unset($this->Stops);
        } else {
            $this->Stops = $stops;
        }
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteOptions|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteOptions $options
     * @return \Pcm\StructType\PcmRoute
     */
    public function setOptions(\Pcm\StructType\PcmRouteOptions $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
    /**
     * Get FuelOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmFuelOptions|null
     */
    public function getFuelOptions()
    {
        return isset($this->FuelOptions) ? $this->FuelOptions : null;
    }
    /**
     * Set FuelOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmFuelOptions $fuelOptions
     * @return \Pcm\StructType\PcmRoute
     */
    public function setFuelOptions(\Pcm\StructType\PcmFuelOptions $fuelOptions = null)
    {
        if (is_null($fuelOptions) || (is_array($fuelOptions) && empty($fuelOptions))) {
            unset($this->FuelOptions);
        } else {
            $this->FuelOptions = $fuelOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
