<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PinDrawer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PinDrawer
 * @package Pcm
 * @subpackage Structs
 */
class PcmPinDrawer extends AbstractStructBase
{
    /**
     * The PointGroupDensity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PointGroupDensity;
    /**
     * The PointSpreadInGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PointSpreadInGroup;
    /**
     * The DrawOnMap
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DrawOnMap;
    /**
     * The Pins
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfPin
     */
    public $Pins;
    /**
     * Constructor method for PinDrawer
     * @uses PcmPinDrawer::setPointGroupDensity()
     * @uses PcmPinDrawer::setPointSpreadInGroup()
     * @uses PcmPinDrawer::setDrawOnMap()
     * @uses PcmPinDrawer::setPins()
     * @param string $pointGroupDensity
     * @param string $pointSpreadInGroup
     * @param bool $drawOnMap
     * @param \Pcm\ArrayType\PcmArrayOfPin $pins
     */
    public function __construct($pointGroupDensity = null, $pointSpreadInGroup = null, $drawOnMap = null, \Pcm\ArrayType\PcmArrayOfPin $pins = null)
    {
        $this
            ->setPointGroupDensity($pointGroupDensity)
            ->setPointSpreadInGroup($pointSpreadInGroup)
            ->setDrawOnMap($drawOnMap)
            ->setPins($pins);
    }
    /**
     * Get PointGroupDensity value
     * @return string|null
     */
    public function getPointGroupDensity()
    {
        return $this->PointGroupDensity;
    }
    /**
     * Set PointGroupDensity value
     * @uses \Pcm\EnumType\PcmPointGroupDensity::valueIsValid()
     * @uses \Pcm\EnumType\PcmPointGroupDensity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pointGroupDensity
     * @return \Pcm\StructType\PcmPinDrawer
     */
    public function setPointGroupDensity($pointGroupDensity = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPointGroupDensity::valueIsValid($pointGroupDensity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pointGroupDensity, implode(', ', \Pcm\EnumType\PcmPointGroupDensity::getValidValues())), __LINE__);
        }
        $this->PointGroupDensity = $pointGroupDensity;
        return $this;
    }
    /**
     * Get PointSpreadInGroup value
     * @return string|null
     */
    public function getPointSpreadInGroup()
    {
        return $this->PointSpreadInGroup;
    }
    /**
     * Set PointSpreadInGroup value
     * @uses \Pcm\EnumType\PcmPointSpread::valueIsValid()
     * @uses \Pcm\EnumType\PcmPointSpread::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pointSpreadInGroup
     * @return \Pcm\StructType\PcmPinDrawer
     */
    public function setPointSpreadInGroup($pointSpreadInGroup = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPointSpread::valueIsValid($pointSpreadInGroup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pointSpreadInGroup, implode(', ', \Pcm\EnumType\PcmPointSpread::getValidValues())), __LINE__);
        }
        $this->PointSpreadInGroup = $pointSpreadInGroup;
        return $this;
    }
    /**
     * Get DrawOnMap value
     * @return bool|null
     */
    public function getDrawOnMap()
    {
        return $this->DrawOnMap;
    }
    /**
     * Set DrawOnMap value
     * @param bool $drawOnMap
     * @return \Pcm\StructType\PcmPinDrawer
     */
    public function setDrawOnMap($drawOnMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($drawOnMap) && !is_bool($drawOnMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($drawOnMap)), __LINE__);
        }
        $this->DrawOnMap = $drawOnMap;
        return $this;
    }
    /**
     * Get Pins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfPin|null
     */
    public function getPins()
    {
        return isset($this->Pins) ? $this->Pins : null;
    }
    /**
     * Set Pins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfPin $pins
     * @return \Pcm\StructType\PcmPinDrawer
     */
    public function setPins(\Pcm\ArrayType\PcmArrayOfPin $pins = null)
    {
        if (is_null($pins) || (is_array($pins) && empty($pins))) {
            unset($this->Pins);
        } else {
            $this->Pins = $pins;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmPinDrawer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
