<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HoursOfServiceLocation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HoursOfServiceLocation
 * @package Pcm
 * @subpackage Structs
 */
class PcmHoursOfServiceLocation extends PcmLocation
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The OnDuty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnDuty;
    /**
     * The EstimatedTimeOfArrival
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedTimeOfArrival;
    /**
     * The EstimatedTimeOfDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedTimeOfDeparture;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * The StopDuration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $StopDuration;
    /**
     * The LegDriveTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LegDriveTime;
    /**
     * The LegDistance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LegDistance;
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $Amenities;
    /**
     * The TruckServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TruckServices;
    /**
     * The AlternateRestStops
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfAlternateHosLocation
     */
    public $AlternateRestStops;
    /**
     * The POIID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $POIID;
    /**
     * Constructor method for HoursOfServiceLocation
     * @uses PcmHoursOfServiceLocation::setType()
     * @uses PcmHoursOfServiceLocation::setOnDuty()
     * @uses PcmHoursOfServiceLocation::setEstimatedTimeOfArrival()
     * @uses PcmHoursOfServiceLocation::setEstimatedTimeOfDeparture()
     * @uses PcmHoursOfServiceLocation::setTimeZone()
     * @uses PcmHoursOfServiceLocation::setStopDuration()
     * @uses PcmHoursOfServiceLocation::setLegDriveTime()
     * @uses PcmHoursOfServiceLocation::setLegDistance()
     * @uses PcmHoursOfServiceLocation::setAmenities()
     * @uses PcmHoursOfServiceLocation::setTruckServices()
     * @uses PcmHoursOfServiceLocation::setAlternateRestStops()
     * @uses PcmHoursOfServiceLocation::setPOIID()
     * @param string $type
     * @param bool $onDuty
     * @param string $estimatedTimeOfArrival
     * @param string $estimatedTimeOfDeparture
     * @param string $timeZone
     * @param float $stopDuration
     * @param float $legDriveTime
     * @param float $legDistance
     * @param \Pcm\ArrayType\PcmArrayOfstring $amenities
     * @param bool $truckServices
     * @param \Pcm\ArrayType\PcmArrayOfAlternateHosLocation $alternateRestStops
     * @param int $pOIID
     */
    public function __construct($type = null, $onDuty = null, $estimatedTimeOfArrival = null, $estimatedTimeOfDeparture = null, $timeZone = null, $stopDuration = null, $legDriveTime = null, $legDistance = null, \Pcm\ArrayType\PcmArrayOfstring $amenities = null, $truckServices = null, \Pcm\ArrayType\PcmArrayOfAlternateHosLocation $alternateRestStops = null, $pOIID = null)
    {
        $this
            ->setType($type)
            ->setOnDuty($onDuty)
            ->setEstimatedTimeOfArrival($estimatedTimeOfArrival)
            ->setEstimatedTimeOfDeparture($estimatedTimeOfDeparture)
            ->setTimeZone($timeZone)
            ->setStopDuration($stopDuration)
            ->setLegDriveTime($legDriveTime)
            ->setLegDistance($legDistance)
            ->setAmenities($amenities)
            ->setTruckServices($truckServices)
            ->setAlternateRestStops($alternateRestStops)
            ->setPOIID($pOIID);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmStopType::valueIsValid()
     * @uses \Pcm\EnumType\PcmStopType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmStopType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmStopType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get OnDuty value
     * @return bool|null
     */
    public function getOnDuty()
    {
        return $this->OnDuty;
    }
    /**
     * Set OnDuty value
     * @param bool $onDuty
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setOnDuty($onDuty = null)
    {
        // validation for constraint: boolean
        if (!is_null($onDuty) && !is_bool($onDuty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onDuty)), __LINE__);
        }
        $this->OnDuty = $onDuty;
        return $this;
    }
    /**
     * Get EstimatedTimeOfArrival value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedTimeOfArrival()
    {
        return isset($this->EstimatedTimeOfArrival) ? $this->EstimatedTimeOfArrival : null;
    }
    /**
     * Set EstimatedTimeOfArrival value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedTimeOfArrival
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setEstimatedTimeOfArrival($estimatedTimeOfArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfArrival) && !is_string($estimatedTimeOfArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedTimeOfArrival)), __LINE__);
        }
        if (is_null($estimatedTimeOfArrival) || (is_array($estimatedTimeOfArrival) && empty($estimatedTimeOfArrival))) {
            unset($this->EstimatedTimeOfArrival);
        } else {
            $this->EstimatedTimeOfArrival = $estimatedTimeOfArrival;
        }
        return $this;
    }
    /**
     * Get EstimatedTimeOfDeparture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedTimeOfDeparture()
    {
        return isset($this->EstimatedTimeOfDeparture) ? $this->EstimatedTimeOfDeparture : null;
    }
    /**
     * Set EstimatedTimeOfDeparture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedTimeOfDeparture
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setEstimatedTimeOfDeparture($estimatedTimeOfDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedTimeOfDeparture) && !is_string($estimatedTimeOfDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedTimeOfDeparture)), __LINE__);
        }
        if (is_null($estimatedTimeOfDeparture) || (is_array($estimatedTimeOfDeparture) && empty($estimatedTimeOfDeparture))) {
            unset($this->EstimatedTimeOfDeparture);
        } else {
            $this->EstimatedTimeOfDeparture = $estimatedTimeOfDeparture;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
    /**
     * Get StopDuration value
     * @return float|null
     */
    public function getStopDuration()
    {
        return $this->StopDuration;
    }
    /**
     * Set StopDuration value
     * @param float $stopDuration
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setStopDuration($stopDuration = null)
    {
        $this->StopDuration = $stopDuration;
        return $this;
    }
    /**
     * Get LegDriveTime value
     * @return float|null
     */
    public function getLegDriveTime()
    {
        return $this->LegDriveTime;
    }
    /**
     * Set LegDriveTime value
     * @param float $legDriveTime
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setLegDriveTime($legDriveTime = null)
    {
        $this->LegDriveTime = $legDriveTime;
        return $this;
    }
    /**
     * Get LegDistance value
     * @return float|null
     */
    public function getLegDistance()
    {
        return $this->LegDistance;
    }
    /**
     * Set LegDistance value
     * @param float $legDistance
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setLegDistance($legDistance = null)
    {
        $this->LegDistance = $legDistance;
        return $this;
    }
    /**
     * Get Amenities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getAmenities()
    {
        return isset($this->Amenities) ? $this->Amenities : null;
    }
    /**
     * Set Amenities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $amenities
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setAmenities(\Pcm\ArrayType\PcmArrayOfstring $amenities = null)
    {
        if (is_null($amenities) || (is_array($amenities) && empty($amenities))) {
            unset($this->Amenities);
        } else {
            $this->Amenities = $amenities;
        }
        return $this;
    }
    /**
     * Get TruckServices value
     * @return bool|null
     */
    public function getTruckServices()
    {
        return $this->TruckServices;
    }
    /**
     * Set TruckServices value
     * @param bool $truckServices
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setTruckServices($truckServices = null)
    {
        // validation for constraint: boolean
        if (!is_null($truckServices) && !is_bool($truckServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($truckServices)), __LINE__);
        }
        $this->TruckServices = $truckServices;
        return $this;
    }
    /**
     * Get AlternateRestStops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfAlternateHosLocation|null
     */
    public function getAlternateRestStops()
    {
        return isset($this->AlternateRestStops) ? $this->AlternateRestStops : null;
    }
    /**
     * Set AlternateRestStops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfAlternateHosLocation $alternateRestStops
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setAlternateRestStops(\Pcm\ArrayType\PcmArrayOfAlternateHosLocation $alternateRestStops = null)
    {
        if (is_null($alternateRestStops) || (is_array($alternateRestStops) && empty($alternateRestStops))) {
            unset($this->AlternateRestStops);
        } else {
            $this->AlternateRestStops = $alternateRestStops;
        }
        return $this;
    }
    /**
     * Get POIID value
     * @return int|null
     */
    public function getPOIID()
    {
        return $this->POIID;
    }
    /**
     * Set POIID value
     * @param int $pOIID
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public function setPOIID($pOIID = null)
    {
        // validation for constraint: int
        if (!is_null($pOIID) && !is_numeric($pOIID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pOIID)), __LINE__);
        }
        $this->POIID = $pOIID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmHoursOfServiceLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
