<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeocodeLocation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeocodeLocation
 * @package Pcm
 * @subpackage Structs
 */
class PcmGeocodeLocation extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmAddress
     */
    public $Address;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The GeoList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GeoList;
    /**
     * The MaxResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResults;
    /**
     * The CitySearchFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CitySearchFilter;
    /**
     * Constructor method for GeocodeLocation
     * @uses PcmGeocodeLocation::setAddress()
     * @uses PcmGeocodeLocation::setRegion()
     * @uses PcmGeocodeLocation::setGeoList()
     * @uses PcmGeocodeLocation::setMaxResults()
     * @uses PcmGeocodeLocation::setCitySearchFilter()
     * @param \Pcm\StructType\PcmAddress $address
     * @param string $region
     * @param bool $geoList
     * @param int $maxResults
     * @param string $citySearchFilter
     */
    public function __construct(\Pcm\StructType\PcmAddress $address = null, $region = null, $geoList = null, $maxResults = null, $citySearchFilter = null)
    {
        $this
            ->setAddress($address)
            ->setRegion($region)
            ->setGeoList($geoList)
            ->setMaxResults($maxResults)
            ->setCitySearchFilter($citySearchFilter);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmAddress $address
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public function setAddress(\Pcm\StructType\PcmAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get GeoList value
     * @return bool|null
     */
    public function getGeoList()
    {
        return $this->GeoList;
    }
    /**
     * Set GeoList value
     * @param bool $geoList
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public function setGeoList($geoList = null)
    {
        // validation for constraint: boolean
        if (!is_null($geoList) && !is_bool($geoList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($geoList)), __LINE__);
        }
        $this->GeoList = $geoList;
        return $this;
    }
    /**
     * Get MaxResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResults()
    {
        return isset($this->MaxResults) ? $this->MaxResults : null;
    }
    /**
     * Set MaxResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResults
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public function setMaxResults($maxResults = null)
    {
        // validation for constraint: int
        if (!is_null($maxResults) && !is_numeric($maxResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResults)), __LINE__);
        }
        if (is_null($maxResults) || (is_array($maxResults) && empty($maxResults))) {
            unset($this->MaxResults);
        } else {
            $this->MaxResults = $maxResults;
        }
        return $this;
    }
    /**
     * Get CitySearchFilter value
     * @return string|null
     */
    public function getCitySearchFilter()
    {
        return $this->CitySearchFilter;
    }
    /**
     * Set CitySearchFilter value
     * @uses \Pcm\EnumType\PcmGeocodeCitySearchFilter::valueIsValid()
     * @uses \Pcm\EnumType\PcmGeocodeCitySearchFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $citySearchFilter
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public function setCitySearchFilter($citySearchFilter = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmGeocodeCitySearchFilter::valueIsValid($citySearchFilter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $citySearchFilter, implode(', ', \Pcm\EnumType\PcmGeocodeCitySearchFilter::getValidValues())), __LINE__);
        }
        $this->CitySearchFilter = $citySearchFilter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGeocodeLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
