<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvoidFavor StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AvoidFavor
 * @package Pcm
 * @subpackage Structs
 */
class PcmAvoidFavor extends AbstractStructBase
{
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The Road
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Road;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for AvoidFavor
     * @uses PcmAvoidFavor::setLabel()
     * @uses PcmAvoidFavor::setRoad()
     * @uses PcmAvoidFavor::setState()
     * @uses PcmAvoidFavor::setType()
     * @param string $label
     * @param string $road
     * @param string $state
     * @param string $type
     */
    public function __construct($label = null, $road = null, $state = null, $type = null)
    {
        $this
            ->setLabel($label)
            ->setRoad($road)
            ->setState($state)
            ->setType($type);
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \Pcm\StructType\PcmAvoidFavor
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get Road value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoad()
    {
        return isset($this->Road) ? $this->Road : null;
    }
    /**
     * Set Road value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $road
     * @return \Pcm\StructType\PcmAvoidFavor
     */
    public function setRoad($road = null)
    {
        // validation for constraint: string
        if (!is_null($road) && !is_string($road)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($road)), __LINE__);
        }
        if (is_null($road) || (is_array($road) && empty($road))) {
            unset($this->Road);
        } else {
            $this->Road = $road;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \Pcm\StructType\PcmAvoidFavor
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmAFType::valueIsValid()
     * @uses \Pcm\EnumType\PcmAFType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmAvoidFavor
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmAFType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmAFType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAvoidFavor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
