<?php

namespace Pcm\EnumType;

/**
 * This class stands for TimeZone EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeZone
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmTimeZone
{
    /**
     * Constant for value 'Local'
     * @return string 'Local'
     */
    const VALUE_LOCAL = 'Local';
    /**
     * Constant for value 'System'
     * @return string 'System'
     */
    const VALUE_SYSTEM = 'System';
    /**
     * Constant for value 'Hawaii'
     * @return string 'Hawaii'
     */
    const VALUE_HAWAII = 'Hawaii';
    /**
     * Constant for value 'Alaska'
     * @return string 'Alaska'
     */
    const VALUE_ALASKA = 'Alaska';
    /**
     * Constant for value 'Pacific'
     * @return string 'Pacific'
     */
    const VALUE_PACIFIC = 'Pacific';
    /**
     * Constant for value 'Arizona'
     * @return string 'Arizona'
     */
    const VALUE_ARIZONA = 'Arizona';
    /**
     * Constant for value 'Mountain'
     * @return string 'Mountain'
     */
    const VALUE_MOUNTAIN = 'Mountain';
    /**
     * Constant for value 'Central'
     * @return string 'Central'
     */
    const VALUE_CENTRAL = 'Central';
    /**
     * Constant for value 'Eastern'
     * @return string 'Eastern'
     */
    const VALUE_EASTERN = 'Eastern';
    /**
     * Constant for value 'Atlantic'
     * @return string 'Atlantic'
     */
    const VALUE_ATLANTIC = 'Atlantic';
    /**
     * Constant for value 'Newfoundland'
     * @return string 'Newfoundland'
     */
    const VALUE_NEWFOUNDLAND = 'Newfoundland';
    /**
     * Constant for value 'GMT'
     * @return string 'GMT'
     */
    const VALUE_GMT = 'GMT';
    /**
     * Constant for value 'UTC'
     * @return string 'UTC'
     */
    const VALUE_UTC = 'UTC';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOCAL
     * @uses self::VALUE_SYSTEM
     * @uses self::VALUE_HAWAII
     * @uses self::VALUE_ALASKA
     * @uses self::VALUE_PACIFIC
     * @uses self::VALUE_ARIZONA
     * @uses self::VALUE_MOUNTAIN
     * @uses self::VALUE_CENTRAL
     * @uses self::VALUE_EASTERN
     * @uses self::VALUE_ATLANTIC
     * @uses self::VALUE_NEWFOUNDLAND
     * @uses self::VALUE_GMT
     * @uses self::VALUE_UTC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOCAL,
            self::VALUE_SYSTEM,
            self::VALUE_HAWAII,
            self::VALUE_ALASKA,
            self::VALUE_PACIFIC,
            self::VALUE_ARIZONA,
            self::VALUE_MOUNTAIN,
            self::VALUE_CENTRAL,
            self::VALUE_EASTERN,
            self::VALUE_ATLANTIC,
            self::VALUE_NEWFOUNDLAND,
            self::VALUE_GMT,
            self::VALUE_UTC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
