<?php

namespace Pcm\EnumType;

/**
 * This class stands for POISearchType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:POISearchType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPOISearchType
{
    /**
     * Constant for value 'FuelStop'
     * @return string 'FuelStop'
     */
    const VALUE_FUEL_STOP = 'FuelStop';
    /**
     * Constant for value 'HoS'
     * @return string 'HoS'
     */
    const VALUE_HO_S = 'HoS';
    /**
     * Constant for value 'Generic'
     * @return string 'Generic'
     */
    const VALUE_GENERIC = 'Generic';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FUEL_STOP
     * @uses self::VALUE_HO_S
     * @uses self::VALUE_GENERIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FUEL_STOP,
            self::VALUE_HO_S,
            self::VALUE_GENERIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
