<?php

namespace Pcm\EnumType;

/**
 * This class stands for Currency EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Currency
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmCurrency
{
    /**
     * Constant for value 'US'
     * @return string 'US'
     */
    const VALUE_US = 'US';
    /**
     * Constant for value 'CDN'
     * @return string 'CDN'
     */
    const VALUE_CDN = 'CDN';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'AMD'
     * @return string 'AMD'
     */
    const VALUE_AMD = 'AMD';
    /**
     * Constant for value 'AZN'
     * @return string 'AZN'
     */
    const VALUE_AZN = 'AZN';
    /**
     * Constant for value 'BAM'
     * @return string 'BAM'
     */
    const VALUE_BAM = 'BAM';
    /**
     * Constant for value 'BGN'
     * @return string 'BGN'
     */
    const VALUE_BGN = 'BGN';
    /**
     * Constant for value 'BYR'
     * @return string 'BYR'
     */
    const VALUE_BYR = 'BYR';
    /**
     * Constant for value 'CHF'
     * @return string 'CHF'
     */
    const VALUE_CHF = 'CHF';
    /**
     * Constant for value 'CZK'
     * @return string 'CZK'
     */
    const VALUE_CZK = 'CZK';
    /**
     * Constant for value 'DKK'
     * @return string 'DKK'
     */
    const VALUE_DKK = 'DKK';
    /**
     * Constant for value 'EUR'
     * @return string 'EUR'
     */
    const VALUE_EUR = 'EUR';
    /**
     * Constant for value 'GBP'
     * @return string 'GBP'
     */
    const VALUE_GBP = 'GBP';
    /**
     * Constant for value 'GEL'
     * @return string 'GEL'
     */
    const VALUE_GEL = 'GEL';
    /**
     * Constant for value 'HRK'
     * @return string 'HRK'
     */
    const VALUE_HRK = 'HRK';
    /**
     * Constant for value 'HUF'
     * @return string 'HUF'
     */
    const VALUE_HUF = 'HUF';
    /**
     * Constant for value 'ISK'
     * @return string 'ISK'
     */
    const VALUE_ISK = 'ISK';
    /**
     * Constant for value 'MDL'
     * @return string 'MDL'
     */
    const VALUE_MDL = 'MDL';
    /**
     * Constant for value 'MKD'
     * @return string 'MKD'
     */
    const VALUE_MKD = 'MKD';
    /**
     * Constant for value 'NOK'
     * @return string 'NOK'
     */
    const VALUE_NOK = 'NOK';
    /**
     * Constant for value 'PLN'
     * @return string 'PLN'
     */
    const VALUE_PLN = 'PLN';
    /**
     * Constant for value 'RON'
     * @return string 'RON'
     */
    const VALUE_RON = 'RON';
    /**
     * Constant for value 'RSD'
     * @return string 'RSD'
     */
    const VALUE_RSD = 'RSD';
    /**
     * Constant for value 'RUB'
     * @return string 'RUB'
     */
    const VALUE_RUB = 'RUB';
    /**
     * Constant for value 'SEK'
     * @return string 'SEK'
     */
    const VALUE_SEK = 'SEK';
    /**
     * Constant for value 'TRY'
     * @return string 'TRY'
     */
    const VALUE_TRY = 'TRY';
    /**
     * Constant for value 'UAH'
     * @return string 'UAH'
     */
    const VALUE_UAH = 'UAH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_US
     * @uses self::VALUE_CDN
     * @uses self::VALUE_ALL
     * @uses self::VALUE_AMD
     * @uses self::VALUE_AZN
     * @uses self::VALUE_BAM
     * @uses self::VALUE_BGN
     * @uses self::VALUE_BYR
     * @uses self::VALUE_CHF
     * @uses self::VALUE_CZK
     * @uses self::VALUE_DKK
     * @uses self::VALUE_EUR
     * @uses self::VALUE_GBP
     * @uses self::VALUE_GEL
     * @uses self::VALUE_HRK
     * @uses self::VALUE_HUF
     * @uses self::VALUE_ISK
     * @uses self::VALUE_MDL
     * @uses self::VALUE_MKD
     * @uses self::VALUE_NOK
     * @uses self::VALUE_PLN
     * @uses self::VALUE_RON
     * @uses self::VALUE_RSD
     * @uses self::VALUE_RUB
     * @uses self::VALUE_SEK
     * @uses self::VALUE_TRY
     * @uses self::VALUE_UAH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_US,
            self::VALUE_CDN,
            self::VALUE_ALL,
            self::VALUE_AMD,
            self::VALUE_AZN,
            self::VALUE_BAM,
            self::VALUE_BGN,
            self::VALUE_BYR,
            self::VALUE_CHF,
            self::VALUE_CZK,
            self::VALUE_DKK,
            self::VALUE_EUR,
            self::VALUE_GBP,
            self::VALUE_GEL,
            self::VALUE_HRK,
            self::VALUE_HUF,
            self::VALUE_ISK,
            self::VALUE_MDL,
            self::VALUE_MKD,
            self::VALUE_NOK,
            self::VALUE_PLN,
            self::VALUE_RON,
            self::VALUE_RSD,
            self::VALUE_RUB,
            self::VALUE_SEK,
            self::VALUE_TRY,
            self::VALUE_UAH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
