<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrailerConfig StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrailerConfig
 * @package Pcm
 * @subpackage Structs
 */
class PcmTrailerConfig extends AbstractStructBase
{
    /**
     * The TypeOfTrailer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeOfTrailer;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The MaxHeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxHeight;
    /**
     * The MaxWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxWeight;
    /**
     * The MaxAxles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAxles;
    /**
     * The Engine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmEngineConfig
     */
    public $Engine;
    /**
     * Constructor method for TrailerConfig
     * @uses PcmTrailerConfig::setTypeOfTrailer()
     * @uses PcmTrailerConfig::setCount()
     * @uses PcmTrailerConfig::setMaxHeight()
     * @uses PcmTrailerConfig::setMaxWeight()
     * @uses PcmTrailerConfig::setMaxAxles()
     * @uses PcmTrailerConfig::setEngine()
     * @param string $typeOfTrailer
     * @param int $count
     * @param string $maxHeight
     * @param int $maxWeight
     * @param int $maxAxles
     * @param \Pcm\StructType\PcmEngineConfig $engine
     */
    public function __construct($typeOfTrailer = null, $count = null, $maxHeight = null, $maxWeight = null, $maxAxles = null, \Pcm\StructType\PcmEngineConfig $engine = null)
    {
        $this
            ->setTypeOfTrailer($typeOfTrailer)
            ->setCount($count)
            ->setMaxHeight($maxHeight)
            ->setMaxWeight($maxWeight)
            ->setMaxAxles($maxAxles)
            ->setEngine($engine);
    }
    /**
     * Get TypeOfTrailer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeOfTrailer()
    {
        return isset($this->TypeOfTrailer) ? $this->TypeOfTrailer : null;
    }
    /**
     * Set TypeOfTrailer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmTrailerType::valueIsValid()
     * @uses \Pcm\EnumType\PcmTrailerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfTrailer
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setTypeOfTrailer($typeOfTrailer = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTrailerType::valueIsValid($typeOfTrailer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeOfTrailer, implode(', ', \Pcm\EnumType\PcmTrailerType::getValidValues())), __LINE__);
        }
        if (is_null($typeOfTrailer) || (is_array($typeOfTrailer) && empty($typeOfTrailer))) {
            unset($this->TypeOfTrailer);
        } else {
            $this->TypeOfTrailer = $typeOfTrailer;
        }
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $count
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get MaxHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxHeight()
    {
        return isset($this->MaxHeight) ? $this->MaxHeight : null;
    }
    /**
     * Set MaxHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxHeight
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setMaxHeight($maxHeight = null)
    {
        // validation for constraint: string
        if (!is_null($maxHeight) && !is_string($maxHeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxHeight)), __LINE__);
        }
        if (is_null($maxHeight) || (is_array($maxHeight) && empty($maxHeight))) {
            unset($this->MaxHeight);
        } else {
            $this->MaxHeight = $maxHeight;
        }
        return $this;
    }
    /**
     * Get MaxWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxWeight()
    {
        return isset($this->MaxWeight) ? $this->MaxWeight : null;
    }
    /**
     * Set MaxWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxWeight
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setMaxWeight($maxWeight = null)
    {
        // validation for constraint: int
        if (!is_null($maxWeight) && !is_numeric($maxWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxWeight)), __LINE__);
        }
        if (is_null($maxWeight) || (is_array($maxWeight) && empty($maxWeight))) {
            unset($this->MaxWeight);
        } else {
            $this->MaxWeight = $maxWeight;
        }
        return $this;
    }
    /**
     * Get MaxAxles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAxles()
    {
        return isset($this->MaxAxles) ? $this->MaxAxles : null;
    }
    /**
     * Set MaxAxles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAxles
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setMaxAxles($maxAxles = null)
    {
        // validation for constraint: int
        if (!is_null($maxAxles) && !is_numeric($maxAxles)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAxles)), __LINE__);
        }
        if (is_null($maxAxles) || (is_array($maxAxles) && empty($maxAxles))) {
            unset($this->MaxAxles);
        } else {
            $this->MaxAxles = $maxAxles;
        }
        return $this;
    }
    /**
     * Get Engine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmEngineConfig|null
     */
    public function getEngine()
    {
        return isset($this->Engine) ? $this->Engine : null;
    }
    /**
     * Set Engine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmEngineConfig $engine
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public function setEngine(\Pcm\StructType\PcmEngineConfig $engine = null)
    {
        if (is_null($engine) || (is_array($engine) && empty($engine))) {
            unset($this->Engine);
        } else {
            $this->Engine = $engine;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmTrailerConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
