<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateReport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StateReport
 * @package Pcm
 * @subpackage Structs
 */
class PcmStateReport extends PcmReport
{
    /**
     * The MileageReportLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfStopReportLine
     */
    public $MileageReportLines;
    /**
     * The StateReportLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfStateCostReportLine
     */
    public $StateReportLines;
    /**
     * Constructor method for StateReport
     * @uses PcmStateReport::setMileageReportLines()
     * @uses PcmStateReport::setStateReportLines()
     * @param \Pcm\ArrayType\PcmArrayOfStopReportLine $mileageReportLines
     * @param \Pcm\ArrayType\PcmArrayOfStateCostReportLine $stateReportLines
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfStopReportLine $mileageReportLines = null, \Pcm\ArrayType\PcmArrayOfStateCostReportLine $stateReportLines = null)
    {
        $this
            ->setMileageReportLines($mileageReportLines)
            ->setStateReportLines($stateReportLines);
    }
    /**
     * Get MileageReportLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfStopReportLine|null
     */
    public function getMileageReportLines()
    {
        return isset($this->MileageReportLines) ? $this->MileageReportLines : null;
    }
    /**
     * Set MileageReportLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfStopReportLine $mileageReportLines
     * @return \Pcm\StructType\PcmStateReport
     */
    public function setMileageReportLines(\Pcm\ArrayType\PcmArrayOfStopReportLine $mileageReportLines = null)
    {
        if (is_null($mileageReportLines) || (is_array($mileageReportLines) && empty($mileageReportLines))) {
            unset($this->MileageReportLines);
        } else {
            $this->MileageReportLines = $mileageReportLines;
        }
        return $this;
    }
    /**
     * Get StateReportLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfStateCostReportLine|null
     */
    public function getStateReportLines()
    {
        return isset($this->StateReportLines) ? $this->StateReportLines : null;
    }
    /**
     * Set StateReportLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfStateCostReportLine $stateReportLines
     * @return \Pcm\StructType\PcmStateReport
     */
    public function setStateReportLines(\Pcm\ArrayType\PcmArrayOfStateCostReportLine $stateReportLines = null)
    {
        if (is_null($stateReportLines) || (is_array($stateReportLines) && empty($stateReportLines))) {
            unset($this->StateReportLines);
        } else {
            $this->StateReportLines = $stateReportLines;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmStateReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
