<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShapeGeometry StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ShapeGeometry
 * @package Pcm
 * @subpackage Structs
 */
class PcmShapeGeometry extends PcmGeometry
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Coordinates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Coordinates;
    /**
     * The Fill
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Fill;
    /**
     * The LineWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LineWidth;
    /**
     * The RadiusHorizontal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RadiusHorizontal;
    /**
     * The RadiusVertical
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RadiusVertical;
    /**
     * Constructor method for ShapeGeometry
     * @uses PcmShapeGeometry::setType()
     * @uses PcmShapeGeometry::setCoordinates()
     * @uses PcmShapeGeometry::setFill()
     * @uses PcmShapeGeometry::setLineWidth()
     * @uses PcmShapeGeometry::setRadiusHorizontal()
     * @uses PcmShapeGeometry::setRadiusVertical()
     * @param string $type
     * @param string $coordinates
     * @param bool $fill
     * @param int $lineWidth
     * @param float $radiusHorizontal
     * @param float $radiusVertical
     */
    public function __construct($type = null, $coordinates = null, $fill = null, $lineWidth = null, $radiusHorizontal = null, $radiusVertical = null)
    {
        $this
            ->setType($type)
            ->setCoordinates($coordinates)
            ->setFill($fill)
            ->setLineWidth($lineWidth)
            ->setRadiusHorizontal($radiusHorizontal)
            ->setRadiusVertical($radiusVertical);
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Pcm\EnumType\PcmShapeType::valueIsValid()
     * @uses \Pcm\EnumType\PcmShapeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmShapeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \Pcm\EnumType\PcmShapeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Coordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoordinates()
    {
        return isset($this->Coordinates) ? $this->Coordinates : null;
    }
    /**
     * Set Coordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coordinates
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setCoordinates($coordinates = null)
    {
        // validation for constraint: string
        if (!is_null($coordinates) && !is_string($coordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coordinates)), __LINE__);
        }
        if (is_null($coordinates) || (is_array($coordinates) && empty($coordinates))) {
            unset($this->Coordinates);
        } else {
            $this->Coordinates = $coordinates;
        }
        return $this;
    }
    /**
     * Get Fill value
     * @return bool|null
     */
    public function getFill()
    {
        return $this->Fill;
    }
    /**
     * Set Fill value
     * @param bool $fill
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setFill($fill = null)
    {
        // validation for constraint: boolean
        if (!is_null($fill) && !is_bool($fill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fill)), __LINE__);
        }
        $this->Fill = $fill;
        return $this;
    }
    /**
     * Get LineWidth value
     * @return int|null
     */
    public function getLineWidth()
    {
        return $this->LineWidth;
    }
    /**
     * Set LineWidth value
     * @param int $lineWidth
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setLineWidth($lineWidth = null)
    {
        // validation for constraint: int
        if (!is_null($lineWidth) && !is_numeric($lineWidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineWidth)), __LINE__);
        }
        $this->LineWidth = $lineWidth;
        return $this;
    }
    /**
     * Get RadiusHorizontal value
     * @return float|null
     */
    public function getRadiusHorizontal()
    {
        return $this->RadiusHorizontal;
    }
    /**
     * Set RadiusHorizontal value
     * @param float $radiusHorizontal
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setRadiusHorizontal($radiusHorizontal = null)
    {
        $this->RadiusHorizontal = $radiusHorizontal;
        return $this;
    }
    /**
     * Get RadiusVertical value
     * @return float|null
     */
    public function getRadiusVertical()
    {
        return $this->RadiusVertical;
    }
    /**
     * Set RadiusVertical value
     * @param float $radiusVertical
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public function setRadiusVertical($radiusVertical = null)
    {
        $this->RadiusVertical = $radiusVertical;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmShapeGeometry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
