<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutePointsResponseBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoutePointsResponseBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoutePointsResponseBody extends AbstractStructBase
{
    /**
     * The RoutePoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfCoordinates
     */
    public $RoutePoints;
    /**
     * The TMinutes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TMinutes;
    /**
     * The TDistance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TDistance;
    /**
     * The PLIDs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfint
     */
    public $PLIDs;
    /**
     * Constructor method for RoutePointsResponseBody
     * @uses PcmRoutePointsResponseBody::setRoutePoints()
     * @uses PcmRoutePointsResponseBody::setTMinutes()
     * @uses PcmRoutePointsResponseBody::setTDistance()
     * @uses PcmRoutePointsResponseBody::setPLIDs()
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfCoordinates $routePoints
     * @param int $tMinutes
     * @param float $tDistance
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfint $pLIDs
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfArrayOfCoordinates $routePoints = null, $tMinutes = null, $tDistance = null, \Pcm\ArrayType\PcmArrayOfArrayOfint $pLIDs = null)
    {
        $this
            ->setRoutePoints($routePoints)
            ->setTMinutes($tMinutes)
            ->setTDistance($tDistance)
            ->setPLIDs($pLIDs);
    }
    /**
     * Get RoutePoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfCoordinates|null
     */
    public function getRoutePoints()
    {
        return isset($this->RoutePoints) ? $this->RoutePoints : null;
    }
    /**
     * Set RoutePoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfCoordinates $routePoints
     * @return \Pcm\StructType\PcmRoutePointsResponseBody
     */
    public function setRoutePoints(\Pcm\ArrayType\PcmArrayOfArrayOfCoordinates $routePoints = null)
    {
        if (is_null($routePoints) || (is_array($routePoints) && empty($routePoints))) {
            unset($this->RoutePoints);
        } else {
            $this->RoutePoints = $routePoints;
        }
        return $this;
    }
    /**
     * Get TMinutes value
     * @return int|null
     */
    public function getTMinutes()
    {
        return $this->TMinutes;
    }
    /**
     * Set TMinutes value
     * @param int $tMinutes
     * @return \Pcm\StructType\PcmRoutePointsResponseBody
     */
    public function setTMinutes($tMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($tMinutes) && !is_numeric($tMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tMinutes)), __LINE__);
        }
        $this->TMinutes = $tMinutes;
        return $this;
    }
    /**
     * Get TDistance value
     * @return float|null
     */
    public function getTDistance()
    {
        return $this->TDistance;
    }
    /**
     * Set TDistance value
     * @param float $tDistance
     * @return \Pcm\StructType\PcmRoutePointsResponseBody
     */
    public function setTDistance($tDistance = null)
    {
        $this->TDistance = $tDistance;
        return $this;
    }
    /**
     * Get PLIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfint|null
     */
    public function getPLIDs()
    {
        return isset($this->PLIDs) ? $this->PLIDs : null;
    }
    /**
     * Set PLIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfint $pLIDs
     * @return \Pcm\StructType\PcmRoutePointsResponseBody
     */
    public function setPLIDs(\Pcm\ArrayType\PcmArrayOfArrayOfint $pLIDs = null)
    {
        if (is_null($pLIDs) || (is_array($pLIDs) && empty($pLIDs))) {
            unset($this->PLIDs);
        } else {
            $this->PLIDs = $pLIDs;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoutePointsResponseBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
