<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Location
 * @package Pcm
 * @subpackage Structs
 */
class PcmLocation extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmAddress
     */
    public $Address;
    /**
     * The Coords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Coords;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The PlaceName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PlaceName;
    /**
     * Constructor method for Location
     * @uses PcmLocation::setAddress()
     * @uses PcmLocation::setCoords()
     * @uses PcmLocation::setRegion()
     * @uses PcmLocation::setLabel()
     * @uses PcmLocation::setPlaceName()
     * @param \Pcm\StructType\PcmAddress $address
     * @param \Pcm\StructType\PcmCoordinates $coords
     * @param string $region
     * @param string $label
     * @param string $placeName
     */
    public function __construct(\Pcm\StructType\PcmAddress $address = null, \Pcm\StructType\PcmCoordinates $coords = null, $region = null, $label = null, $placeName = null)
    {
        $this
            ->setAddress($address)
            ->setCoords($coords)
            ->setRegion($region)
            ->setLabel($label)
            ->setPlaceName($placeName);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmAddress $address
     * @return \Pcm\StructType\PcmLocation
     */
    public function setAddress(\Pcm\StructType\PcmAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Coords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCoords()
    {
        return isset($this->Coords) ? $this->Coords : null;
    }
    /**
     * Set Coords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $coords
     * @return \Pcm\StructType\PcmLocation
     */
    public function setCoords(\Pcm\StructType\PcmCoordinates $coords = null)
    {
        if (is_null($coords) || (is_array($coords) && empty($coords))) {
            unset($this->Coords);
        } else {
            $this->Coords = $coords;
        }
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmLocation
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \Pcm\StructType\PcmLocation
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get PlaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaceName()
    {
        return isset($this->PlaceName) ? $this->PlaceName : null;
    }
    /**
     * Set PlaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $placeName
     * @return \Pcm\StructType\PcmLocation
     */
    public function setPlaceName($placeName = null)
    {
        // validation for constraint: string
        if (!is_null($placeName) && !is_string($placeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeName)), __LINE__);
        }
        if (is_null($placeName) || (is_array($placeName) && empty($placeName))) {
            unset($this->PlaceName);
        } else {
            $this->PlaceName = $placeName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
