<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distance StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Distance
 * @package Pcm
 * @subpackage Structs
 */
class PcmDistance extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * The DistanceUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DistanceUnits;
    /**
     * Constructor method for Distance
     * @uses PcmDistance::setValue()
     * @uses PcmDistance::setDistanceUnits()
     * @param float $value
     * @param string $distanceUnits
     */
    public function __construct($value = null, $distanceUnits = null)
    {
        $this
            ->setValue($value)
            ->setDistanceUnits($distanceUnits);
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \Pcm\StructType\PcmDistance
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Get DistanceUnits value
     * @return string|null
     */
    public function getDistanceUnits()
    {
        return $this->DistanceUnits;
    }
    /**
     * Set DistanceUnits value
     * @uses \Pcm\EnumType\PcmDistanceUnits::valueIsValid()
     * @uses \Pcm\EnumType\PcmDistanceUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnits
     * @return \Pcm\StructType\PcmDistance
     */
    public function setDistanceUnits($distanceUnits = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDistanceUnits::valueIsValid($distanceUnits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distanceUnits, implode(', ', \Pcm\EnumType\PcmDistanceUnits::getValidValues())), __LINE__);
        }
        $this->DistanceUnits = $distanceUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmDistance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
