<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DateTimeType
 * @package Pcm
 * @subpackage Structs
 */
class PcmDateTimeType extends AbstractStructBase
{
    /**
     * The CalendarDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CalendarDate;
    /**
     * The DayOfWeek
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DayOfWeek;
    /**
     * The TimeOfDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeOfDay;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TimeZone;
    /**
     * Constructor method for DateTimeType
     * @uses PcmDateTimeType::setCalendarDate()
     * @uses PcmDateTimeType::setDayOfWeek()
     * @uses PcmDateTimeType::setTimeOfDay()
     * @uses PcmDateTimeType::setTimeZone()
     * @param string $calendarDate
     * @param string $dayOfWeek
     * @param string $timeOfDay
     * @param string $timeZone
     */
    public function __construct($calendarDate = null, $dayOfWeek = null, $timeOfDay = null, $timeZone = null)
    {
        $this
            ->setCalendarDate($calendarDate)
            ->setDayOfWeek($dayOfWeek)
            ->setTimeOfDay($timeOfDay)
            ->setTimeZone($timeZone);
    }
    /**
     * Get CalendarDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalendarDate()
    {
        return isset($this->CalendarDate) ? $this->CalendarDate : null;
    }
    /**
     * Set CalendarDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calendarDate
     * @return \Pcm\StructType\PcmDateTimeType
     */
    public function setCalendarDate($calendarDate = null)
    {
        // validation for constraint: string
        if (!is_null($calendarDate) && !is_string($calendarDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calendarDate)), __LINE__);
        }
        if (is_null($calendarDate) || (is_array($calendarDate) && empty($calendarDate))) {
            unset($this->CalendarDate);
        } else {
            $this->CalendarDate = $calendarDate;
        }
        return $this;
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @uses \Pcm\EnumType\PcmDayOfWeek::valueIsValid()
     * @uses \Pcm\EnumType\PcmDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfWeek
     * @return \Pcm\StructType\PcmDateTimeType
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDayOfWeek::valueIsValid($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfWeek, implode(', ', \Pcm\EnumType\PcmDayOfWeek::getValidValues())), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get TimeOfDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeOfDay()
    {
        return isset($this->TimeOfDay) ? $this->TimeOfDay : null;
    }
    /**
     * Set TimeOfDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeOfDay
     * @return \Pcm\StructType\PcmDateTimeType
     */
    public function setTimeOfDay($timeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($timeOfDay) && !is_string($timeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeOfDay)), __LINE__);
        }
        if (is_null($timeOfDay) || (is_array($timeOfDay) && empty($timeOfDay))) {
            unset($this->TimeOfDay);
        } else {
            $this->TimeOfDay = $timeOfDay;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @uses \Pcm\EnumType\PcmTimeZone::valueIsValid()
     * @uses \Pcm\EnumType\PcmTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \Pcm\StructType\PcmDateTimeType
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \Pcm\EnumType\PcmTimeZone::getValidValues())), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmDateTimeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
