<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPlaceLocation StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomPlaceLocation
 * @package Pcm
 * @subpackage Structs
 */
class PcmCustomPlaceLocation extends AbstractStructBase
{
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmLocation
     */
    public $Location;
    /**
     * Constructor method for CustomPlaceLocation
     * @uses PcmCustomPlaceLocation::setAction()
     * @uses PcmCustomPlaceLocation::setLocation()
     * @param string $action
     * @param \Pcm\StructType\PcmLocation $location
     */
    public function __construct($action = null, \Pcm\StructType\PcmLocation $location = null)
    {
        $this
            ->setAction($action)
            ->setLocation($location);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \Pcm\EnumType\PcmActionType::valueIsValid()
     * @uses \Pcm\EnumType\PcmActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \Pcm\StructType\PcmCustomPlaceLocation
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmActionType::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $action, implode(', ', \Pcm\EnumType\PcmActionType::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmLocation|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmLocation $location
     * @return \Pcm\StructType\PcmCustomPlaceLocation
     */
    public function setLocation(\Pcm\StructType\PcmLocation $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmCustomPlaceLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
