<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddGeofence StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AddGeofence
 * @package Pcm
 * @subpackage Structs
 */
class PcmAddGeofence extends AbstractStructBase
{
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Radius;
    /**
     * The SetId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SetId;
    /**
     * The ShapePoints
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfArrayOfdouble
     */
    public $ShapePoints;
    /**
     * The ShapeType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShapeType;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * Constructor method for AddGeofence
     * @uses PcmAddGeofence::setEndTime()
     * @uses PcmAddGeofence::setLabel()
     * @uses PcmAddGeofence::setName()
     * @uses PcmAddGeofence::setRadius()
     * @uses PcmAddGeofence::setSetId()
     * @uses PcmAddGeofence::setShapePoints()
     * @uses PcmAddGeofence::setShapeType()
     * @uses PcmAddGeofence::setStartTime()
     * @param string $endTime
     * @param string $label
     * @param string $name
     * @param float $radius
     * @param int $setId
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfdouble $shapePoints
     * @param string $shapeType
     * @param string $startTime
     */
    public function __construct($endTime = null, $label = null, $name = null, $radius = null, $setId = null, \Pcm\ArrayType\PcmArrayOfArrayOfdouble $shapePoints = null, $shapeType = null, $startTime = null)
    {
        $this
            ->setEndTime($endTime)
            ->setLabel($label)
            ->setName($name)
            ->setRadius($radius)
            ->setSetId($setId)
            ->setShapePoints($shapePoints)
            ->setShapeType($shapeType)
            ->setStartTime($startTime);
    }
    /**
     * Get EndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndTime()
    {
        return isset($this->EndTime) ? $this->EndTime : null;
    }
    /**
     * Set EndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endTime
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        if (is_null($endTime) || (is_array($endTime) && empty($endTime))) {
            unset($this->EndTime);
        } else {
            $this->EndTime = $endTime;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Radius value
     * @return float|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param float $radius
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setRadius($radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get SetId value
     * @return int|null
     */
    public function getSetId()
    {
        return $this->SetId;
    }
    /**
     * Set SetId value
     * @param int $setId
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setSetId($setId = null)
    {
        // validation for constraint: int
        if (!is_null($setId) && !is_numeric($setId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($setId)), __LINE__);
        }
        $this->SetId = $setId;
        return $this;
    }
    /**
     * Get ShapePoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfArrayOfdouble|null
     */
    public function getShapePoints()
    {
        return isset($this->ShapePoints) ? $this->ShapePoints : null;
    }
    /**
     * Set ShapePoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfArrayOfdouble $shapePoints
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setShapePoints(\Pcm\ArrayType\PcmArrayOfArrayOfdouble $shapePoints = null)
    {
        if (is_null($shapePoints) || (is_array($shapePoints) && empty($shapePoints))) {
            unset($this->ShapePoints);
        } else {
            $this->ShapePoints = $shapePoints;
        }
        return $this;
    }
    /**
     * Get ShapeType value
     * @return string|null
     */
    public function getShapeType()
    {
        return $this->ShapeType;
    }
    /**
     * Set ShapeType value
     * @uses \Pcm\EnumType\PcmGeofenceShape::valueIsValid()
     * @uses \Pcm\EnumType\PcmGeofenceShape::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shapeType
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setShapeType($shapeType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmGeofenceShape::valueIsValid($shapeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shapeType, implode(', ', \Pcm\EnumType\PcmGeofenceShape::getValidValues())), __LINE__);
        }
        $this->ShapeType = $shapeType;
        return $this;
    }
    /**
     * Get StartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartTime()
    {
        return isset($this->StartTime) ? $this->StartTime : null;
    }
    /**
     * Set StartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startTime
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        if (is_null($startTime) || (is_array($startTime) && empty($startTime))) {
            unset($this->StartTime);
        } else {
            $this->StartTime = $startTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmAddGeofence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
