<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ALKShadow StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ALKShadow
 * @package Pcm
 * @subpackage Structs
 */
class PcmALKShadow extends AbstractStructBase
{
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRGB
     */
    public $Color;
    /**
     * The Opacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Opacity;
    /**
     * The OffsetX
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OffsetX;
    /**
     * The OffsetY
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OffsetY;
    /**
     * Constructor method for ALKShadow
     * @uses PcmALKShadow::setColor()
     * @uses PcmALKShadow::setOpacity()
     * @uses PcmALKShadow::setOffsetX()
     * @uses PcmALKShadow::setOffsetY()
     * @param \Pcm\StructType\PcmRGB $color
     * @param string $opacity
     * @param string $offsetX
     * @param string $offsetY
     */
    public function __construct(\Pcm\StructType\PcmRGB $color = null, $opacity = null, $offsetX = null, $offsetY = null)
    {
        $this
            ->setColor($color)
            ->setOpacity($opacity)
            ->setOffsetX($offsetX)
            ->setOffsetY($offsetY);
    }
    /**
     * Get Color value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRGB|null
     */
    public function getColor()
    {
        return isset($this->Color) ? $this->Color : null;
    }
    /**
     * Set Color value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRGB $color
     * @return \Pcm\StructType\PcmALKShadow
     */
    public function setColor(\Pcm\StructType\PcmRGB $color = null)
    {
        if (is_null($color) || (is_array($color) && empty($color))) {
            unset($this->Color);
        } else {
            $this->Color = $color;
        }
        return $this;
    }
    /**
     * Get Opacity value
     * @return string|null
     */
    public function getOpacity()
    {
        return $this->Opacity;
    }
    /**
     * Set Opacity value
     * @param string $opacity
     * @return \Pcm\StructType\PcmALKShadow
     */
    public function setOpacity($opacity = null)
    {
        // validation for constraint: string
        if (!is_null($opacity) && !is_string($opacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opacity)), __LINE__);
        }
        $this->Opacity = $opacity;
        return $this;
    }
    /**
     * Get OffsetX value
     * @return string|null
     */
    public function getOffsetX()
    {
        return $this->OffsetX;
    }
    /**
     * Set OffsetX value
     * @param string $offsetX
     * @return \Pcm\StructType\PcmALKShadow
     */
    public function setOffsetX($offsetX = null)
    {
        // validation for constraint: string
        if (!is_null($offsetX) && !is_string($offsetX)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offsetX)), __LINE__);
        }
        $this->OffsetX = $offsetX;
        return $this;
    }
    /**
     * Get OffsetY value
     * @return string|null
     */
    public function getOffsetY()
    {
        return $this->OffsetY;
    }
    /**
     * Set OffsetY value
     * @param string $offsetY
     * @return \Pcm\StructType\PcmALKShadow
     */
    public function setOffsetY($offsetY = null)
    {
        // validation for constraint: string
        if (!is_null($offsetY) && !is_string($offsetY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offsetY)), __LINE__);
        }
        $this->OffsetY = $offsetY;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmALKShadow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
