<?php

namespace Pcm\EnumType;

/**
 * This class stands for RouteSyncMessageVersion EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteSyncMessageVersion
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmRouteSyncMessageVersion
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'V3'
     * @return string 'V3'
     */
    const VALUE_V_3 = 'V3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_V_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_V_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
