<?php

namespace Pcm\EnumType;

/**
 * This class stands for LegendType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LegendType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmLegendType
{
    /**
     * Constant for value 'ScaleOfMiles'
     * @return string 'ScaleOfMiles'
     */
    const VALUE_SCALE_OF_MILES = 'ScaleOfMiles';
    /**
     * Constant for value 'RouteLegend'
     * @return string 'RouteLegend'
     */
    const VALUE_ROUTE_LEGEND = 'RouteLegend';
    /**
     * Constant for value 'RoadLegend'
     * @return string 'RoadLegend'
     */
    const VALUE_ROAD_LEGEND = 'RoadLegend';
    /**
     * Constant for value 'HazMatLegend'
     * @return string 'HazMatLegend'
     */
    const VALUE_HAZ_MAT_LEGEND = 'HazMatLegend';
    /**
     * Constant for value 'TrafficLegend'
     * @return string 'TrafficLegend'
     */
    const VALUE_TRAFFIC_LEGEND = 'TrafficLegend';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCALE_OF_MILES
     * @uses self::VALUE_ROUTE_LEGEND
     * @uses self::VALUE_ROAD_LEGEND
     * @uses self::VALUE_HAZ_MAT_LEGEND
     * @uses self::VALUE_TRAFFIC_LEGEND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCALE_OF_MILES,
            self::VALUE_ROUTE_LEGEND,
            self::VALUE_ROAD_LEGEND,
            self::VALUE_HAZ_MAT_LEGEND,
            self::VALUE_TRAFFIC_LEGEND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
