<?php

namespace Pcm\EnumType;

/**
 * This class stands for GeofenceState EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeofenceState
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmGeofenceState
{
    /**
     * Constant for value 'Off'
     * @return string 'Off'
     */
    const VALUE_OFF = 'Off';
    /**
     * Constant for value 'Warn'
     * @return string 'Warn'
     */
    const VALUE_WARN = 'Warn';
    /**
     * Constant for value 'Avoid'
     * @return string 'Avoid'
     */
    const VALUE_AVOID = 'Avoid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OFF
     * @uses self::VALUE_WARN
     * @uses self::VALUE_AVOID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OFF,
            self::VALUE_WARN,
            self::VALUE_AVOID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
