<?php

namespace Pcm\EnumType;

/**
 * This class stands for ETAETDType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ETAETDType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmETAETDType
{
    /**
     * Constant for value 'Arrival'
     * @return string 'Arrival'
     */
    const VALUE_ARRIVAL = 'Arrival';
    /**
     * Constant for value 'Depart'
     * @return string 'Depart'
     */
    const VALUE_DEPART = 'Depart';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARRIVAL
     * @uses self::VALUE_DEPART
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARRIVAL,
            self::VALUE_DEPART,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
