<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoadReport ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRoadReport
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfRoadReport extends AbstractStructArrayBase
{
    /**
     * The RoadReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRoadReport[]
     */
    public $RoadReport;
    /**
     * Constructor method for ArrayOfRoadReport
     * @uses PcmArrayOfRoadReport::setRoadReport()
     * @param \Pcm\StructType\PcmRoadReport[] $roadReport
     */
    public function __construct(array $roadReport = array())
    {
        $this
            ->setRoadReport($roadReport);
    }
    /**
     * Get RoadReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRoadReport[]|null
     */
    public function getRoadReport()
    {
        return isset($this->RoadReport) ? $this->RoadReport : null;
    }
    /**
     * Set RoadReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRoadReport[] $roadReport
     * @return \Pcm\ArrayType\PcmArrayOfRoadReport
     */
    public function setRoadReport(array $roadReport = array())
    {
        foreach ($roadReport as $arrayOfRoadReportRoadReportItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoadReportRoadReportItem instanceof \Pcm\StructType\PcmRoadReport) {
                throw new \InvalidArgumentException(sprintf('The RoadReport property can only contain items of \Pcm\StructType\PcmRoadReport, "%s" given', is_object($arrayOfRoadReportRoadReportItem) ? get_class($arrayOfRoadReportRoadReportItem) : gettype($arrayOfRoadReportRoadReportItem)), __LINE__);
            }
        }
        if (is_null($roadReport) || (is_array($roadReport) && empty($roadReport))) {
            unset($this->RoadReport);
        } else {
            $this->RoadReport = $roadReport;
        }
        return $this;
    }
    /**
     * Add item to RoadReport value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmRoadReport $item
     * @return \Pcm\ArrayType\PcmArrayOfRoadReport
     */
    public function addToRoadReport(\Pcm\StructType\PcmRoadReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmRoadReport) {
            throw new \InvalidArgumentException(sprintf('The RoadReport property can only contain items of \Pcm\StructType\PcmRoadReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoadReport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmRoadReport|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmRoadReport|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmRoadReport|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmRoadReport|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmRoadReport|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoadReport
     */
    public function getAttributeName()
    {
        return 'RoadReport';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfRoadReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
