<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLayer ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLayer
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfLayer extends AbstractStructArrayBase
{
    /**
     * The Layer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmLayer[]
     */
    public $Layer;
    /**
     * Constructor method for ArrayOfLayer
     * @uses PcmArrayOfLayer::setLayer()
     * @param \Pcm\StructType\PcmLayer[] $layer
     */
    public function __construct(array $layer = array())
    {
        $this
            ->setLayer($layer);
    }
    /**
     * Get Layer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmLayer[]|null
     */
    public function getLayer()
    {
        return isset($this->Layer) ? $this->Layer : null;
    }
    /**
     * Set Layer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmLayer[] $layer
     * @return \Pcm\ArrayType\PcmArrayOfLayer
     */
    public function setLayer(array $layer = array())
    {
        foreach ($layer as $arrayOfLayerLayerItem) {
            // validation for constraint: itemType
            if (!$arrayOfLayerLayerItem instanceof \Pcm\StructType\PcmLayer) {
                throw new \InvalidArgumentException(sprintf('The Layer property can only contain items of \Pcm\StructType\PcmLayer, "%s" given', is_object($arrayOfLayerLayerItem) ? get_class($arrayOfLayerLayerItem) : gettype($arrayOfLayerLayerItem)), __LINE__);
            }
        }
        if (is_null($layer) || (is_array($layer) && empty($layer))) {
            unset($this->Layer);
        } else {
            $this->Layer = $layer;
        }
        return $this;
    }
    /**
     * Add item to Layer value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmLayer $item
     * @return \Pcm\ArrayType\PcmArrayOfLayer
     */
    public function addToLayer(\Pcm\StructType\PcmLayer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmLayer) {
            throw new \InvalidArgumentException(sprintf('The Layer property can only contain items of \Pcm\StructType\PcmLayer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Layer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmLayer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmLayer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmLayer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmLayer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmLayer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Layer
     */
    public function getAttributeName()
    {
        return 'Layer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfLayer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
