<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDirectionsReport ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDirectionsReport
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfDirectionsReport extends AbstractStructArrayBase
{
    /**
     * The DirectionsReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmDirectionsReport[]
     */
    public $DirectionsReport;
    /**
     * Constructor method for ArrayOfDirectionsReport
     * @uses PcmArrayOfDirectionsReport::setDirectionsReport()
     * @param \Pcm\StructType\PcmDirectionsReport[] $directionsReport
     */
    public function __construct(array $directionsReport = array())
    {
        $this
            ->setDirectionsReport($directionsReport);
    }
    /**
     * Get DirectionsReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmDirectionsReport[]|null
     */
    public function getDirectionsReport()
    {
        return isset($this->DirectionsReport) ? $this->DirectionsReport : null;
    }
    /**
     * Set DirectionsReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmDirectionsReport[] $directionsReport
     * @return \Pcm\ArrayType\PcmArrayOfDirectionsReport
     */
    public function setDirectionsReport(array $directionsReport = array())
    {
        foreach ($directionsReport as $arrayOfDirectionsReportDirectionsReportItem) {
            // validation for constraint: itemType
            if (!$arrayOfDirectionsReportDirectionsReportItem instanceof \Pcm\StructType\PcmDirectionsReport) {
                throw new \InvalidArgumentException(sprintf('The DirectionsReport property can only contain items of \Pcm\StructType\PcmDirectionsReport, "%s" given', is_object($arrayOfDirectionsReportDirectionsReportItem) ? get_class($arrayOfDirectionsReportDirectionsReportItem) : gettype($arrayOfDirectionsReportDirectionsReportItem)), __LINE__);
            }
        }
        if (is_null($directionsReport) || (is_array($directionsReport) && empty($directionsReport))) {
            unset($this->DirectionsReport);
        } else {
            $this->DirectionsReport = $directionsReport;
        }
        return $this;
    }
    /**
     * Add item to DirectionsReport value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmDirectionsReport $item
     * @return \Pcm\ArrayType\PcmArrayOfDirectionsReport
     */
    public function addToDirectionsReport(\Pcm\StructType\PcmDirectionsReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmDirectionsReport) {
            throw new \InvalidArgumentException(sprintf('The DirectionsReport property can only contain items of \Pcm\StructType\PcmDirectionsReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DirectionsReport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmDirectionsReport|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmDirectionsReport|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmDirectionsReport|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmDirectionsReport|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmDirectionsReport|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DirectionsReport
     */
    public function getAttributeName()
    {
        return 'DirectionsReport';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfDirectionsReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
