<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeatherAlertsBaseRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WeatherAlertsBaseRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmWeatherAlertsBaseRequestBody extends AbstractStructBase
{
    /**
     * The Urgency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Urgency;
    /**
     * The Severity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Severity;
    /**
     * The Certainty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Certainty;
    /**
     * The EventNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $EventNames;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndTime;
    /**
     * Constructor method for WeatherAlertsBaseRequestBody
     * @uses PcmWeatherAlertsBaseRequestBody::setUrgency()
     * @uses PcmWeatherAlertsBaseRequestBody::setSeverity()
     * @uses PcmWeatherAlertsBaseRequestBody::setCertainty()
     * @uses PcmWeatherAlertsBaseRequestBody::setEventNames()
     * @uses PcmWeatherAlertsBaseRequestBody::setStartTime()
     * @uses PcmWeatherAlertsBaseRequestBody::setEndTime()
     * @param string $urgency
     * @param string $severity
     * @param string $certainty
     * @param \Pcm\ArrayType\PcmArrayOfstring $eventNames
     * @param string $startTime
     * @param string $endTime
     */
    public function __construct($urgency = null, $severity = null, $certainty = null, \Pcm\ArrayType\PcmArrayOfstring $eventNames = null, $startTime = null, $endTime = null)
    {
        $this
            ->setUrgency($urgency)
            ->setSeverity($severity)
            ->setCertainty($certainty)
            ->setEventNames($eventNames)
            ->setStartTime($startTime)
            ->setEndTime($endTime);
    }
    /**
     * Get Urgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrgency()
    {
        return isset($this->Urgency) ? $this->Urgency : null;
    }
    /**
     * Set Urgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertUrgency::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertUrgency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $urgency
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setUrgency($urgency = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertUrgency::valueIsValid($urgency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $urgency, implode(', ', \Pcm\EnumType\PcmWeatherAlertUrgency::getValidValues())), __LINE__);
        }
        if (is_null($urgency) || (is_array($urgency) && empty($urgency))) {
            unset($this->Urgency);
        } else {
            $this->Urgency = $urgency;
        }
        return $this;
    }
    /**
     * Get Severity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeverity()
    {
        return isset($this->Severity) ? $this->Severity : null;
    }
    /**
     * Set Severity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertSeverity::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $severity
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setSeverity($severity = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertSeverity::valueIsValid($severity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $severity, implode(', ', \Pcm\EnumType\PcmWeatherAlertSeverity::getValidValues())), __LINE__);
        }
        if (is_null($severity) || (is_array($severity) && empty($severity))) {
            unset($this->Severity);
        } else {
            $this->Severity = $severity;
        }
        return $this;
    }
    /**
     * Get Certainty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertainty()
    {
        return isset($this->Certainty) ? $this->Certainty : null;
    }
    /**
     * Set Certainty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Pcm\EnumType\PcmWeatherAlertCertainty::valueIsValid()
     * @uses \Pcm\EnumType\PcmWeatherAlertCertainty::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certainty
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setCertainty($certainty = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmWeatherAlertCertainty::valueIsValid($certainty)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certainty, implode(', ', \Pcm\EnumType\PcmWeatherAlertCertainty::getValidValues())), __LINE__);
        }
        if (is_null($certainty) || (is_array($certainty) && empty($certainty))) {
            unset($this->Certainty);
        } else {
            $this->Certainty = $certainty;
        }
        return $this;
    }
    /**
     * Get EventNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getEventNames()
    {
        return isset($this->EventNames) ? $this->EventNames : null;
    }
    /**
     * Set EventNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $eventNames
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setEventNames(\Pcm\ArrayType\PcmArrayOfstring $eventNames = null)
    {
        if (is_null($eventNames) || (is_array($eventNames) && empty($eventNames))) {
            unset($this->EventNames);
        } else {
            $this->EventNames = $eventNames;
        }
        return $this;
    }
    /**
     * Get StartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartTime()
    {
        return isset($this->StartTime) ? $this->StartTime : null;
    }
    /**
     * Set StartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startTime
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        if (is_null($startTime) || (is_array($startTime) && empty($startTime))) {
            unset($this->StartTime);
        } else {
            $this->StartTime = $startTime;
        }
        return $this;
    }
    /**
     * Get EndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndTime()
    {
        return isset($this->EndTime) ? $this->EndTime : null;
    }
    /**
     * Set EndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endTime
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        if (is_null($endTime) || (is_array($endTime) && empty($endTime))) {
            unset($this->EndTime);
        } else {
            $this->EndTime = $endTime;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmWeatherAlertsBaseRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
