<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpeedLimit StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpeedLimit
 * @package Pcm
 * @subpackage Structs
 */
class PcmSpeedLimit extends AbstractStructBase
{
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Speed;
    /**
     * The SpeedType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SpeedType;
    /**
     * The SpeedTypeString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpeedTypeString;
    /**
     * The LinkIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkIds;
    /**
     * The RoadClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoadClass;
    /**
     * The Units
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Units;
    /**
     * Constructor method for SpeedLimit
     * @uses PcmSpeedLimit::setSpeed()
     * @uses PcmSpeedLimit::setSpeedType()
     * @uses PcmSpeedLimit::setSpeedTypeString()
     * @uses PcmSpeedLimit::setLinkIds()
     * @uses PcmSpeedLimit::setRoadClass()
     * @uses PcmSpeedLimit::setUnits()
     * @param int $speed
     * @param string $speedType
     * @param string $speedTypeString
     * @param string $linkIds
     * @param string $roadClass
     * @param string $units
     */
    public function __construct($speed = null, $speedType = null, $speedTypeString = null, $linkIds = null, $roadClass = null, $units = null)
    {
        $this
            ->setSpeed($speed)
            ->setSpeedType($speedType)
            ->setSpeedTypeString($speedTypeString)
            ->setLinkIds($linkIds)
            ->setRoadClass($roadClass)
            ->setUnits($units);
    }
    /**
     * Get Speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get SpeedType value
     * @return string|null
     */
    public function getSpeedType()
    {
        return $this->SpeedType;
    }
    /**
     * Set SpeedType value
     * @uses \Pcm\EnumType\PcmSpeedLimitType::valueIsValid()
     * @uses \Pcm\EnumType\PcmSpeedLimitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $speedType
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setSpeedType($speedType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmSpeedLimitType::valueIsValid($speedType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $speedType, implode(', ', \Pcm\EnumType\PcmSpeedLimitType::getValidValues())), __LINE__);
        }
        $this->SpeedType = $speedType;
        return $this;
    }
    /**
     * Get SpeedTypeString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpeedTypeString()
    {
        return isset($this->SpeedTypeString) ? $this->SpeedTypeString : null;
    }
    /**
     * Set SpeedTypeString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $speedTypeString
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setSpeedTypeString($speedTypeString = null)
    {
        // validation for constraint: string
        if (!is_null($speedTypeString) && !is_string($speedTypeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($speedTypeString)), __LINE__);
        }
        if (is_null($speedTypeString) || (is_array($speedTypeString) && empty($speedTypeString))) {
            unset($this->SpeedTypeString);
        } else {
            $this->SpeedTypeString = $speedTypeString;
        }
        return $this;
    }
    /**
     * Get LinkIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkIds()
    {
        return isset($this->LinkIds) ? $this->LinkIds : null;
    }
    /**
     * Set LinkIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkIds
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setLinkIds($linkIds = null)
    {
        // validation for constraint: string
        if (!is_null($linkIds) && !is_string($linkIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkIds)), __LINE__);
        }
        if (is_null($linkIds) || (is_array($linkIds) && empty($linkIds))) {
            unset($this->LinkIds);
        } else {
            $this->LinkIds = $linkIds;
        }
        return $this;
    }
    /**
     * Get RoadClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoadClass()
    {
        return isset($this->RoadClass) ? $this->RoadClass : null;
    }
    /**
     * Set RoadClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roadClass
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setRoadClass($roadClass = null)
    {
        // validation for constraint: string
        if (!is_null($roadClass) && !is_string($roadClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roadClass)), __LINE__);
        }
        if (is_null($roadClass) || (is_array($roadClass) && empty($roadClass))) {
            unset($this->RoadClass);
        } else {
            $this->RoadClass = $roadClass;
        }
        return $this;
    }
    /**
     * Get Units value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnits()
    {
        return isset($this->Units) ? $this->Units : null;
    }
    /**
     * Set Units value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $units
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public function setUnits($units = null)
    {
        // validation for constraint: string
        if (!is_null($units) && !is_string($units)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($units)), __LINE__);
        }
        if (is_null($units) || (is_array($units) && empty($units))) {
            unset($this->Units);
        } else {
            $this->Units = $units;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmSpeedLimit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
