<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteOptions StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteOptions
 * @package Pcm
 * @subpackage Structs
 */
class PcmRouteOptions extends AbstractStructBase
{
    /**
     * The AFSetIDs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfint
     */
    public $AFSetIDs;
    /**
     * The AFSetNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $AFSetNames;
    /**
     * The BordersOpen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BordersOpen;
    /**
     * The ClassOverrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassOverrides;
    /**
     * The CustomRoadSpeeds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfRoadSpeedBase
     */
    public $CustomRoadSpeeds;
    /**
     * The DistanceUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DistanceUnits;
    /**
     * The ElevLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ElevLimit;
    /**
     * The FerryDiscourage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FerryDiscourage;
    /**
     * The FuelRoute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FuelRoute;
    /**
     * The GovernorSpeedLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GovernorSpeedLimit;
    /**
     * The HazMatType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HazMatType;
    /**
     * The HighwayOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HighwayOnly;
    /**
     * The HoSOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmHoursOfServiceOptions
     */
    public $HoSOptions;
    /**
     * The HubRouting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HubRouting;
    /**
     * The OverrideRestrict
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OverrideRestrict;
    /**
     * The RouteOptimization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RouteOptimization;
    /**
     * The RoutingType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoutingType;
    /**
     * The SideOfStreetAdherence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SideOfStreetAdherence;
    /**
     * The TollDiscourage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TollDiscourage;
    /**
     * The TrailerCfg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmTrailerConfig
     */
    public $TrailerCfg;
    /**
     * The TruckCfg
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmTruckConfig
     */
    public $TruckCfg;
    /**
     * The UseAvoidsAndFavors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseAvoidsAndFavors;
    /**
     * The UseSites
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseSites;
    /**
     * The VehicleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VehicleType;
    /**
     * Constructor method for RouteOptions
     * @uses PcmRouteOptions::setAFSetIDs()
     * @uses PcmRouteOptions::setAFSetNames()
     * @uses PcmRouteOptions::setBordersOpen()
     * @uses PcmRouteOptions::setClassOverrides()
     * @uses PcmRouteOptions::setCustomRoadSpeeds()
     * @uses PcmRouteOptions::setDistanceUnits()
     * @uses PcmRouteOptions::setElevLimit()
     * @uses PcmRouteOptions::setFerryDiscourage()
     * @uses PcmRouteOptions::setFuelRoute()
     * @uses PcmRouteOptions::setGovernorSpeedLimit()
     * @uses PcmRouteOptions::setHazMatType()
     * @uses PcmRouteOptions::setHighwayOnly()
     * @uses PcmRouteOptions::setHoSOptions()
     * @uses PcmRouteOptions::setHubRouting()
     * @uses PcmRouteOptions::setOverrideRestrict()
     * @uses PcmRouteOptions::setRouteOptimization()
     * @uses PcmRouteOptions::setRoutingType()
     * @uses PcmRouteOptions::setSideOfStreetAdherence()
     * @uses PcmRouteOptions::setTollDiscourage()
     * @uses PcmRouteOptions::setTrailerCfg()
     * @uses PcmRouteOptions::setTruckCfg()
     * @uses PcmRouteOptions::setUseAvoidsAndFavors()
     * @uses PcmRouteOptions::setUseSites()
     * @uses PcmRouteOptions::setVehicleType()
     * @param \Pcm\ArrayType\PcmArrayOfint $aFSetIDs
     * @param \Pcm\ArrayType\PcmArrayOfstring $aFSetNames
     * @param bool $bordersOpen
     * @param string $classOverrides
     * @param \Pcm\ArrayType\PcmArrayOfRoadSpeedBase $customRoadSpeeds
     * @param string $distanceUnits
     * @param int $elevLimit
     * @param bool $ferryDiscourage
     * @param bool $fuelRoute
     * @param int $governorSpeedLimit
     * @param string $hazMatType
     * @param bool $highwayOnly
     * @param \Pcm\StructType\PcmHoursOfServiceOptions $hoSOptions
     * @param bool $hubRouting
     * @param bool $overrideRestrict
     * @param string $routeOptimization
     * @param string $routingType
     * @param string $sideOfStreetAdherence
     * @param bool $tollDiscourage
     * @param \Pcm\StructType\PcmTrailerConfig $trailerCfg
     * @param \Pcm\StructType\PcmTruckConfig $truckCfg
     * @param bool $useAvoidsAndFavors
     * @param bool $useSites
     * @param string $vehicleType
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfint $aFSetIDs = null, \Pcm\ArrayType\PcmArrayOfstring $aFSetNames = null, $bordersOpen = null, $classOverrides = null, \Pcm\ArrayType\PcmArrayOfRoadSpeedBase $customRoadSpeeds = null, $distanceUnits = null, $elevLimit = null, $ferryDiscourage = null, $fuelRoute = null, $governorSpeedLimit = null, $hazMatType = null, $highwayOnly = null, \Pcm\StructType\PcmHoursOfServiceOptions $hoSOptions = null, $hubRouting = null, $overrideRestrict = null, $routeOptimization = null, $routingType = null, $sideOfStreetAdherence = null, $tollDiscourage = null, \Pcm\StructType\PcmTrailerConfig $trailerCfg = null, \Pcm\StructType\PcmTruckConfig $truckCfg = null, $useAvoidsAndFavors = null, $useSites = null, $vehicleType = null)
    {
        $this
            ->setAFSetIDs($aFSetIDs)
            ->setAFSetNames($aFSetNames)
            ->setBordersOpen($bordersOpen)
            ->setClassOverrides($classOverrides)
            ->setCustomRoadSpeeds($customRoadSpeeds)
            ->setDistanceUnits($distanceUnits)
            ->setElevLimit($elevLimit)
            ->setFerryDiscourage($ferryDiscourage)
            ->setFuelRoute($fuelRoute)
            ->setGovernorSpeedLimit($governorSpeedLimit)
            ->setHazMatType($hazMatType)
            ->setHighwayOnly($highwayOnly)
            ->setHoSOptions($hoSOptions)
            ->setHubRouting($hubRouting)
            ->setOverrideRestrict($overrideRestrict)
            ->setRouteOptimization($routeOptimization)
            ->setRoutingType($routingType)
            ->setSideOfStreetAdherence($sideOfStreetAdherence)
            ->setTollDiscourage($tollDiscourage)
            ->setTrailerCfg($trailerCfg)
            ->setTruckCfg($truckCfg)
            ->setUseAvoidsAndFavors($useAvoidsAndFavors)
            ->setUseSites($useSites)
            ->setVehicleType($vehicleType);
    }
    /**
     * Get AFSetIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function getAFSetIDs()
    {
        return isset($this->AFSetIDs) ? $this->AFSetIDs : null;
    }
    /**
     * Set AFSetIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfint $aFSetIDs
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setAFSetIDs(\Pcm\ArrayType\PcmArrayOfint $aFSetIDs = null)
    {
        if (is_null($aFSetIDs) || (is_array($aFSetIDs) && empty($aFSetIDs))) {
            unset($this->AFSetIDs);
        } else {
            $this->AFSetIDs = $aFSetIDs;
        }
        return $this;
    }
    /**
     * Get AFSetNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getAFSetNames()
    {
        return isset($this->AFSetNames) ? $this->AFSetNames : null;
    }
    /**
     * Set AFSetNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $aFSetNames
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setAFSetNames(\Pcm\ArrayType\PcmArrayOfstring $aFSetNames = null)
    {
        if (is_null($aFSetNames) || (is_array($aFSetNames) && empty($aFSetNames))) {
            unset($this->AFSetNames);
        } else {
            $this->AFSetNames = $aFSetNames;
        }
        return $this;
    }
    /**
     * Get BordersOpen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBordersOpen()
    {
        return isset($this->BordersOpen) ? $this->BordersOpen : null;
    }
    /**
     * Set BordersOpen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bordersOpen
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setBordersOpen($bordersOpen = null)
    {
        // validation for constraint: boolean
        if (!is_null($bordersOpen) && !is_bool($bordersOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bordersOpen)), __LINE__);
        }
        if (is_null($bordersOpen) || (is_array($bordersOpen) && empty($bordersOpen))) {
            unset($this->BordersOpen);
        } else {
            $this->BordersOpen = $bordersOpen;
        }
        return $this;
    }
    /**
     * Get ClassOverrides value
     * @return string|null
     */
    public function getClassOverrides()
    {
        return $this->ClassOverrides;
    }
    /**
     * Set ClassOverrides value
     * @uses \Pcm\EnumType\PcmClassOverrideType::valueIsValid()
     * @uses \Pcm\EnumType\PcmClassOverrideType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classOverrides
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setClassOverrides($classOverrides = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmClassOverrideType::valueIsValid($classOverrides)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $classOverrides, implode(', ', \Pcm\EnumType\PcmClassOverrideType::getValidValues())), __LINE__);
        }
        $this->ClassOverrides = $classOverrides;
        return $this;
    }
    /**
     * Get CustomRoadSpeeds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfRoadSpeedBase|null
     */
    public function getCustomRoadSpeeds()
    {
        return isset($this->CustomRoadSpeeds) ? $this->CustomRoadSpeeds : null;
    }
    /**
     * Set CustomRoadSpeeds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfRoadSpeedBase $customRoadSpeeds
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setCustomRoadSpeeds(\Pcm\ArrayType\PcmArrayOfRoadSpeedBase $customRoadSpeeds = null)
    {
        if (is_null($customRoadSpeeds) || (is_array($customRoadSpeeds) && empty($customRoadSpeeds))) {
            unset($this->CustomRoadSpeeds);
        } else {
            $this->CustomRoadSpeeds = $customRoadSpeeds;
        }
        return $this;
    }
    /**
     * Get DistanceUnits value
     * @return string|null
     */
    public function getDistanceUnits()
    {
        return $this->DistanceUnits;
    }
    /**
     * Set DistanceUnits value
     * @uses \Pcm\EnumType\PcmDistanceUnits::valueIsValid()
     * @uses \Pcm\EnumType\PcmDistanceUnits::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnits
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setDistanceUnits($distanceUnits = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDistanceUnits::valueIsValid($distanceUnits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distanceUnits, implode(', ', \Pcm\EnumType\PcmDistanceUnits::getValidValues())), __LINE__);
        }
        $this->DistanceUnits = $distanceUnits;
        return $this;
    }
    /**
     * Get ElevLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getElevLimit()
    {
        return isset($this->ElevLimit) ? $this->ElevLimit : null;
    }
    /**
     * Set ElevLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $elevLimit
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setElevLimit($elevLimit = null)
    {
        // validation for constraint: int
        if (!is_null($elevLimit) && !is_numeric($elevLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($elevLimit)), __LINE__);
        }
        if (is_null($elevLimit) || (is_array($elevLimit) && empty($elevLimit))) {
            unset($this->ElevLimit);
        } else {
            $this->ElevLimit = $elevLimit;
        }
        return $this;
    }
    /**
     * Get FerryDiscourage value
     * @return bool|null
     */
    public function getFerryDiscourage()
    {
        return $this->FerryDiscourage;
    }
    /**
     * Set FerryDiscourage value
     * @param bool $ferryDiscourage
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setFerryDiscourage($ferryDiscourage = null)
    {
        // validation for constraint: boolean
        if (!is_null($ferryDiscourage) && !is_bool($ferryDiscourage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ferryDiscourage)), __LINE__);
        }
        $this->FerryDiscourage = $ferryDiscourage;
        return $this;
    }
    /**
     * Get FuelRoute value
     * @return bool|null
     */
    public function getFuelRoute()
    {
        return $this->FuelRoute;
    }
    /**
     * Set FuelRoute value
     * @param bool $fuelRoute
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setFuelRoute($fuelRoute = null)
    {
        // validation for constraint: boolean
        if (!is_null($fuelRoute) && !is_bool($fuelRoute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fuelRoute)), __LINE__);
        }
        $this->FuelRoute = $fuelRoute;
        return $this;
    }
    /**
     * Get GovernorSpeedLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGovernorSpeedLimit()
    {
        return isset($this->GovernorSpeedLimit) ? $this->GovernorSpeedLimit : null;
    }
    /**
     * Set GovernorSpeedLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $governorSpeedLimit
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setGovernorSpeedLimit($governorSpeedLimit = null)
    {
        // validation for constraint: int
        if (!is_null($governorSpeedLimit) && !is_numeric($governorSpeedLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($governorSpeedLimit)), __LINE__);
        }
        if (is_null($governorSpeedLimit) || (is_array($governorSpeedLimit) && empty($governorSpeedLimit))) {
            unset($this->GovernorSpeedLimit);
        } else {
            $this->GovernorSpeedLimit = $governorSpeedLimit;
        }
        return $this;
    }
    /**
     * Get HazMatType value
     * @return string|null
     */
    public function getHazMatType()
    {
        return $this->HazMatType;
    }
    /**
     * Set HazMatType value
     * @uses \Pcm\EnumType\PcmHazMatType::valueIsValid()
     * @uses \Pcm\EnumType\PcmHazMatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hazMatType
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setHazMatType($hazMatType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmHazMatType::valueIsValid($hazMatType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hazMatType, implode(', ', \Pcm\EnumType\PcmHazMatType::getValidValues())), __LINE__);
        }
        $this->HazMatType = $hazMatType;
        return $this;
    }
    /**
     * Get HighwayOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHighwayOnly()
    {
        return isset($this->HighwayOnly) ? $this->HighwayOnly : null;
    }
    /**
     * Set HighwayOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $highwayOnly
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setHighwayOnly($highwayOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($highwayOnly) && !is_bool($highwayOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($highwayOnly)), __LINE__);
        }
        if (is_null($highwayOnly) || (is_array($highwayOnly) && empty($highwayOnly))) {
            unset($this->HighwayOnly);
        } else {
            $this->HighwayOnly = $highwayOnly;
        }
        return $this;
    }
    /**
     * Get HoSOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmHoursOfServiceOptions|null
     */
    public function getHoSOptions()
    {
        return isset($this->HoSOptions) ? $this->HoSOptions : null;
    }
    /**
     * Set HoSOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmHoursOfServiceOptions $hoSOptions
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setHoSOptions(\Pcm\StructType\PcmHoursOfServiceOptions $hoSOptions = null)
    {
        if (is_null($hoSOptions) || (is_array($hoSOptions) && empty($hoSOptions))) {
            unset($this->HoSOptions);
        } else {
            $this->HoSOptions = $hoSOptions;
        }
        return $this;
    }
    /**
     * Get HubRouting value
     * @return bool|null
     */
    public function getHubRouting()
    {
        return $this->HubRouting;
    }
    /**
     * Set HubRouting value
     * @param bool $hubRouting
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setHubRouting($hubRouting = null)
    {
        // validation for constraint: boolean
        if (!is_null($hubRouting) && !is_bool($hubRouting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hubRouting)), __LINE__);
        }
        $this->HubRouting = $hubRouting;
        return $this;
    }
    /**
     * Get OverrideRestrict value
     * @return bool|null
     */
    public function getOverrideRestrict()
    {
        return $this->OverrideRestrict;
    }
    /**
     * Set OverrideRestrict value
     * @param bool $overrideRestrict
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setOverrideRestrict($overrideRestrict = null)
    {
        // validation for constraint: boolean
        if (!is_null($overrideRestrict) && !is_bool($overrideRestrict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overrideRestrict)), __LINE__);
        }
        $this->OverrideRestrict = $overrideRestrict;
        return $this;
    }
    /**
     * Get RouteOptimization value
     * @return string|null
     */
    public function getRouteOptimization()
    {
        return $this->RouteOptimization;
    }
    /**
     * Set RouteOptimization value
     * @uses \Pcm\EnumType\PcmRouteOptimizeType::valueIsValid()
     * @uses \Pcm\EnumType\PcmRouteOptimizeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeOptimization
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setRouteOptimization($routeOptimization = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmRouteOptimizeType::valueIsValid($routeOptimization)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeOptimization, implode(', ', \Pcm\EnumType\PcmRouteOptimizeType::getValidValues())), __LINE__);
        }
        $this->RouteOptimization = $routeOptimization;
        return $this;
    }
    /**
     * Get RoutingType value
     * @return string|null
     */
    public function getRoutingType()
    {
        return $this->RoutingType;
    }
    /**
     * Set RoutingType value
     * @uses \Pcm\EnumType\PcmRoutingType::valueIsValid()
     * @uses \Pcm\EnumType\PcmRoutingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routingType
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setRoutingType($routingType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmRoutingType::valueIsValid($routingType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routingType, implode(', ', \Pcm\EnumType\PcmRoutingType::getValidValues())), __LINE__);
        }
        $this->RoutingType = $routingType;
        return $this;
    }
    /**
     * Get SideOfStreetAdherence value
     * @return string|null
     */
    public function getSideOfStreetAdherence()
    {
        return $this->SideOfStreetAdherence;
    }
    /**
     * Set SideOfStreetAdherence value
     * @uses \Pcm\EnumType\PcmSideOfStreetAdherenceLevel::valueIsValid()
     * @uses \Pcm\EnumType\PcmSideOfStreetAdherenceLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sideOfStreetAdherence
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setSideOfStreetAdherence($sideOfStreetAdherence = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmSideOfStreetAdherenceLevel::valueIsValid($sideOfStreetAdherence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sideOfStreetAdherence, implode(', ', \Pcm\EnumType\PcmSideOfStreetAdherenceLevel::getValidValues())), __LINE__);
        }
        $this->SideOfStreetAdherence = $sideOfStreetAdherence;
        return $this;
    }
    /**
     * Get TollDiscourage value
     * @return bool|null
     */
    public function getTollDiscourage()
    {
        return $this->TollDiscourage;
    }
    /**
     * Set TollDiscourage value
     * @param bool $tollDiscourage
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setTollDiscourage($tollDiscourage = null)
    {
        // validation for constraint: boolean
        if (!is_null($tollDiscourage) && !is_bool($tollDiscourage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tollDiscourage)), __LINE__);
        }
        $this->TollDiscourage = $tollDiscourage;
        return $this;
    }
    /**
     * Get TrailerCfg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmTrailerConfig|null
     */
    public function getTrailerCfg()
    {
        return isset($this->TrailerCfg) ? $this->TrailerCfg : null;
    }
    /**
     * Set TrailerCfg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmTrailerConfig $trailerCfg
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setTrailerCfg(\Pcm\StructType\PcmTrailerConfig $trailerCfg = null)
    {
        if (is_null($trailerCfg) || (is_array($trailerCfg) && empty($trailerCfg))) {
            unset($this->TrailerCfg);
        } else {
            $this->TrailerCfg = $trailerCfg;
        }
        return $this;
    }
    /**
     * Get TruckCfg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmTruckConfig|null
     */
    public function getTruckCfg()
    {
        return isset($this->TruckCfg) ? $this->TruckCfg : null;
    }
    /**
     * Set TruckCfg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmTruckConfig $truckCfg
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setTruckCfg(\Pcm\StructType\PcmTruckConfig $truckCfg = null)
    {
        if (is_null($truckCfg) || (is_array($truckCfg) && empty($truckCfg))) {
            unset($this->TruckCfg);
        } else {
            $this->TruckCfg = $truckCfg;
        }
        return $this;
    }
    /**
     * Get UseAvoidsAndFavors value
     * @return bool|null
     */
    public function getUseAvoidsAndFavors()
    {
        return $this->UseAvoidsAndFavors;
    }
    /**
     * Set UseAvoidsAndFavors value
     * @param bool $useAvoidsAndFavors
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setUseAvoidsAndFavors($useAvoidsAndFavors = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAvoidsAndFavors) && !is_bool($useAvoidsAndFavors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useAvoidsAndFavors)), __LINE__);
        }
        $this->UseAvoidsAndFavors = $useAvoidsAndFavors;
        return $this;
    }
    /**
     * Get UseSites value
     * @return bool|null
     */
    public function getUseSites()
    {
        return $this->UseSites;
    }
    /**
     * Set UseSites value
     * @param bool $useSites
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setUseSites($useSites = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSites) && !is_bool($useSites)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useSites)), __LINE__);
        }
        $this->UseSites = $useSites;
        return $this;
    }
    /**
     * Get VehicleType value
     * @return string|null
     */
    public function getVehicleType()
    {
        return $this->VehicleType;
    }
    /**
     * Set VehicleType value
     * @uses \Pcm\EnumType\PcmVehicleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleType
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public function setVehicleType($vehicleType = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVehicleType::valueIsValid($vehicleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleType, implode(', ', \Pcm\EnumType\PcmVehicleType::getValidValues())), __LINE__);
        }
        $this->VehicleType = $vehicleType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRouteOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
