<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoadSpeedsRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RoadSpeedsRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmRoadSpeedsRequestBody extends AbstractStructBase
{
    /**
     * The Jurisdiction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Jurisdiction;
    /**
     * The AbbreviationFormat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AbbreviationFormat;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vehicle;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * Constructor method for RoadSpeedsRequestBody
     * @uses PcmRoadSpeedsRequestBody::setJurisdiction()
     * @uses PcmRoadSpeedsRequestBody::setAbbreviationFormat()
     * @uses PcmRoadSpeedsRequestBody::setVehicle()
     * @uses PcmRoadSpeedsRequestBody::setRegion()
     * @param string $jurisdiction
     * @param string $abbreviationFormat
     * @param string $vehicle
     * @param string $region
     */
    public function __construct($jurisdiction = null, $abbreviationFormat = null, $vehicle = null, $region = null)
    {
        $this
            ->setJurisdiction($jurisdiction)
            ->setAbbreviationFormat($abbreviationFormat)
            ->setVehicle($vehicle)
            ->setRegion($region);
    }
    /**
     * Get Jurisdiction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJurisdiction()
    {
        return isset($this->Jurisdiction) ? $this->Jurisdiction : null;
    }
    /**
     * Set Jurisdiction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jurisdiction
     * @return \Pcm\StructType\PcmRoadSpeedsRequestBody
     */
    public function setJurisdiction($jurisdiction = null)
    {
        // validation for constraint: string
        if (!is_null($jurisdiction) && !is_string($jurisdiction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jurisdiction)), __LINE__);
        }
        if (is_null($jurisdiction) || (is_array($jurisdiction) && empty($jurisdiction))) {
            unset($this->Jurisdiction);
        } else {
            $this->Jurisdiction = $jurisdiction;
        }
        return $this;
    }
    /**
     * Get AbbreviationFormat value
     * @return string|null
     */
    public function getAbbreviationFormat()
    {
        return $this->AbbreviationFormat;
    }
    /**
     * Set AbbreviationFormat value
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid()
     * @uses \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $abbreviationFormat
     * @return \Pcm\StructType\PcmRoadSpeedsRequestBody
     */
    public function setAbbreviationFormat($abbreviationFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmCountryAbbreviationType::valueIsValid($abbreviationFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $abbreviationFormat, implode(', ', \Pcm\EnumType\PcmCountryAbbreviationType::getValidValues())), __LINE__);
        }
        $this->AbbreviationFormat = $abbreviationFormat;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return string|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @uses \Pcm\EnumType\PcmVehicleType::valueIsValid()
     * @uses \Pcm\EnumType\PcmVehicleType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicle
     * @return \Pcm\StructType\PcmRoadSpeedsRequestBody
     */
    public function setVehicle($vehicle = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmVehicleType::valueIsValid($vehicle)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicle, implode(', ', \Pcm\EnumType\PcmVehicleType::getValidValues())), __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmRoadSpeedsRequestBody
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmRoadSpeedsRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
