<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportResponseBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportResponseBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmReportResponseBody extends AbstractStructBase
{
    /**
     * The Reports
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfReport
     */
    public $Reports;
    /**
     * Constructor method for ReportResponseBody
     * @uses PcmReportResponseBody::setReports()
     * @param \Pcm\ArrayType\PcmArrayOfReport $reports
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfReport $reports = null)
    {
        $this
            ->setReports($reports);
    }
    /**
     * Get Reports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfReport|null
     */
    public function getReports()
    {
        return isset($this->Reports) ? $this->Reports : null;
    }
    /**
     * Set Reports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfReport $reports
     * @return \Pcm\StructType\PcmReportResponseBody
     */
    public function setReports(\Pcm\ArrayType\PcmArrayOfReport $reports = null)
    {
        if (is_null($reports) || (is_array($reports) && empty($reports))) {
            unset($this->Reports);
        } else {
            $this->Reports = $reports;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReportResponseBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
