<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReduceTripRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReduceTripRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmReduceTripRequestBody extends AbstractStructBase
{
    /**
     * The ExtendedOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmSharedOptions
     */
    public $ExtendedOptions;
    /**
     * The HighwayOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HighwayOnly;
    /**
     * The OffRouteMiles
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $OffRouteMiles;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The ReportType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmReportType
     */
    public $ReportType;
    /**
     * The RoutePings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfCoordinates
     */
    public $RoutePings;
    /**
     * The RoutingOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteOptions
     */
    public $RoutingOptions;
    /**
     * Constructor method for ReduceTripRequestBody
     * @uses PcmReduceTripRequestBody::setExtendedOptions()
     * @uses PcmReduceTripRequestBody::setHighwayOnly()
     * @uses PcmReduceTripRequestBody::setOffRouteMiles()
     * @uses PcmReduceTripRequestBody::setRegion()
     * @uses PcmReduceTripRequestBody::setReportType()
     * @uses PcmReduceTripRequestBody::setRoutePings()
     * @uses PcmReduceTripRequestBody::setRoutingOptions()
     * @param \Pcm\StructType\PcmSharedOptions $extendedOptions
     * @param bool $highwayOnly
     * @param float $offRouteMiles
     * @param string $region
     * @param \Pcm\StructType\PcmReportType $reportType
     * @param \Pcm\ArrayType\PcmArrayOfCoordinates $routePings
     * @param \Pcm\StructType\PcmRouteOptions $routingOptions
     */
    public function __construct(\Pcm\StructType\PcmSharedOptions $extendedOptions = null, $highwayOnly = null, $offRouteMiles = null, $region = null, \Pcm\StructType\PcmReportType $reportType = null, \Pcm\ArrayType\PcmArrayOfCoordinates $routePings = null, \Pcm\StructType\PcmRouteOptions $routingOptions = null)
    {
        $this
            ->setExtendedOptions($extendedOptions)
            ->setHighwayOnly($highwayOnly)
            ->setOffRouteMiles($offRouteMiles)
            ->setRegion($region)
            ->setReportType($reportType)
            ->setRoutePings($routePings)
            ->setRoutingOptions($routingOptions);
    }
    /**
     * Get ExtendedOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmSharedOptions|null
     */
    public function getExtendedOptions()
    {
        return isset($this->ExtendedOptions) ? $this->ExtendedOptions : null;
    }
    /**
     * Set ExtendedOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmSharedOptions $extendedOptions
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setExtendedOptions(\Pcm\StructType\PcmSharedOptions $extendedOptions = null)
    {
        if (is_null($extendedOptions) || (is_array($extendedOptions) && empty($extendedOptions))) {
            unset($this->ExtendedOptions);
        } else {
            $this->ExtendedOptions = $extendedOptions;
        }
        return $this;
    }
    /**
     * Get HighwayOnly value
     * @return bool|null
     */
    public function getHighwayOnly()
    {
        return $this->HighwayOnly;
    }
    /**
     * Set HighwayOnly value
     * @param bool $highwayOnly
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setHighwayOnly($highwayOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($highwayOnly) && !is_bool($highwayOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($highwayOnly)), __LINE__);
        }
        $this->HighwayOnly = $highwayOnly;
        return $this;
    }
    /**
     * Get OffRouteMiles value
     * @return float|null
     */
    public function getOffRouteMiles()
    {
        return $this->OffRouteMiles;
    }
    /**
     * Set OffRouteMiles value
     * @param float $offRouteMiles
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setOffRouteMiles($offRouteMiles = null)
    {
        $this->OffRouteMiles = $offRouteMiles;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmDataRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmDataRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmDataRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmDataRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get ReportType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmReportType|null
     */
    public function getReportType()
    {
        return isset($this->ReportType) ? $this->ReportType : null;
    }
    /**
     * Set ReportType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmReportType $reportType
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setReportType(\Pcm\StructType\PcmReportType $reportType = null)
    {
        if (is_null($reportType) || (is_array($reportType) && empty($reportType))) {
            unset($this->ReportType);
        } else {
            $this->ReportType = $reportType;
        }
        return $this;
    }
    /**
     * Get RoutePings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfCoordinates|null
     */
    public function getRoutePings()
    {
        return isset($this->RoutePings) ? $this->RoutePings : null;
    }
    /**
     * Set RoutePings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfCoordinates $routePings
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setRoutePings(\Pcm\ArrayType\PcmArrayOfCoordinates $routePings = null)
    {
        if (is_null($routePings) || (is_array($routePings) && empty($routePings))) {
            unset($this->RoutePings);
        } else {
            $this->RoutePings = $routePings;
        }
        return $this;
    }
    /**
     * Get RoutingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteOptions|null
     */
    public function getRoutingOptions()
    {
        return isset($this->RoutingOptions) ? $this->RoutingOptions : null;
    }
    /**
     * Set RoutingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteOptions $routingOptions
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public function setRoutingOptions(\Pcm\StructType\PcmRouteOptions $routingOptions = null)
    {
        if (is_null($routingOptions) || (is_array($routingOptions) && empty($routingOptions))) {
            unset($this->RoutingOptions);
        } else {
            $this->RoutingOptions = $routingOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmReduceTripRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
