<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MapViewport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MapViewport
 * @package Pcm
 * @subpackage Structs
 */
class PcmMapViewport extends AbstractStructBase
{
    /**
     * The Center
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $Center;
    /**
     * The ScreenCenter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmPoint
     */
    public $ScreenCenter;
    /**
     * The ZoomRadius
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ZoomRadius;
    /**
     * The CornerA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $CornerA;
    /**
     * The CornerB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmCoordinates
     */
    public $CornerB;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * Constructor method for MapViewport
     * @uses PcmMapViewport::setCenter()
     * @uses PcmMapViewport::setScreenCenter()
     * @uses PcmMapViewport::setZoomRadius()
     * @uses PcmMapViewport::setCornerA()
     * @uses PcmMapViewport::setCornerB()
     * @uses PcmMapViewport::setRegion()
     * @param \Pcm\StructType\PcmCoordinates $center
     * @param \Pcm\StructType\PcmPoint $screenCenter
     * @param float $zoomRadius
     * @param \Pcm\StructType\PcmCoordinates $cornerA
     * @param \Pcm\StructType\PcmCoordinates $cornerB
     * @param string $region
     */
    public function __construct(\Pcm\StructType\PcmCoordinates $center = null, \Pcm\StructType\PcmPoint $screenCenter = null, $zoomRadius = null, \Pcm\StructType\PcmCoordinates $cornerA = null, \Pcm\StructType\PcmCoordinates $cornerB = null, $region = null)
    {
        $this
            ->setCenter($center)
            ->setScreenCenter($screenCenter)
            ->setZoomRadius($zoomRadius)
            ->setCornerA($cornerA)
            ->setCornerB($cornerB)
            ->setRegion($region);
    }
    /**
     * Get Center value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCenter()
    {
        return isset($this->Center) ? $this->Center : null;
    }
    /**
     * Set Center value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $center
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setCenter(\Pcm\StructType\PcmCoordinates $center = null)
    {
        if (is_null($center) || (is_array($center) && empty($center))) {
            unset($this->Center);
        } else {
            $this->Center = $center;
        }
        return $this;
    }
    /**
     * Get ScreenCenter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmPoint|null
     */
    public function getScreenCenter()
    {
        return isset($this->ScreenCenter) ? $this->ScreenCenter : null;
    }
    /**
     * Set ScreenCenter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmPoint $screenCenter
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setScreenCenter(\Pcm\StructType\PcmPoint $screenCenter = null)
    {
        if (is_null($screenCenter) || (is_array($screenCenter) && empty($screenCenter))) {
            unset($this->ScreenCenter);
        } else {
            $this->ScreenCenter = $screenCenter;
        }
        return $this;
    }
    /**
     * Get ZoomRadius value
     * @return float|null
     */
    public function getZoomRadius()
    {
        return $this->ZoomRadius;
    }
    /**
     * Set ZoomRadius value
     * @param float $zoomRadius
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setZoomRadius($zoomRadius = null)
    {
        $this->ZoomRadius = $zoomRadius;
        return $this;
    }
    /**
     * Get CornerA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCornerA()
    {
        return isset($this->CornerA) ? $this->CornerA : null;
    }
    /**
     * Set CornerA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $cornerA
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setCornerA(\Pcm\StructType\PcmCoordinates $cornerA = null)
    {
        if (is_null($cornerA) || (is_array($cornerA) && empty($cornerA))) {
            unset($this->CornerA);
        } else {
            $this->CornerA = $cornerA;
        }
        return $this;
    }
    /**
     * Get CornerB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmCoordinates|null
     */
    public function getCornerB()
    {
        return isset($this->CornerB) ? $this->CornerB : null;
    }
    /**
     * Set CornerB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmCoordinates $cornerB
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setCornerB(\Pcm\StructType\PcmCoordinates $cornerB = null)
    {
        if (is_null($cornerB) || (is_array($cornerB) && empty($cornerB))) {
            unset($this->CornerB);
        } else {
            $this->CornerB = $cornerB;
        }
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @uses \Pcm\EnumType\PcmMapRegion::valueIsValid()
     * @uses \Pcm\EnumType\PcmMapRegion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $region
     * @return \Pcm\StructType\PcmMapViewport
     */
    public function setRegion($region = null)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmMapRegion::valueIsValid($region)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $region, implode(', ', \Pcm\EnumType\PcmMapRegion::getValidValues())), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmMapViewport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
