<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeastCostReport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LeastCostReport
 * @package Pcm
 * @subpackage Structs
 */
class PcmLeastCostReport extends PcmReport
{
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmGeocodeOutputLocation
     */
    public $Destination;
    /**
     * The ReportLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfComparisonReportLine
     */
    public $ReportLines;
    /**
     * Constructor method for LeastCostReport
     * @uses PcmLeastCostReport::setOrigin()
     * @uses PcmLeastCostReport::setDestination()
     * @uses PcmLeastCostReport::setReportLines()
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $origin
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $destination
     * @param \Pcm\ArrayType\PcmArrayOfComparisonReportLine $reportLines
     */
    public function __construct(\Pcm\StructType\PcmGeocodeOutputLocation $origin = null, \Pcm\StructType\PcmGeocodeOutputLocation $destination = null, \Pcm\ArrayType\PcmArrayOfComparisonReportLine $reportLines = null)
    {
        $this
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setReportLines($reportLines);
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $origin
     * @return \Pcm\StructType\PcmLeastCostReport
     */
    public function setOrigin(\Pcm\StructType\PcmGeocodeOutputLocation $origin = null)
    {
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmGeocodeOutputLocation|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmGeocodeOutputLocation $destination
     * @return \Pcm\StructType\PcmLeastCostReport
     */
    public function setDestination(\Pcm\StructType\PcmGeocodeOutputLocation $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get ReportLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfComparisonReportLine|null
     */
    public function getReportLines()
    {
        return isset($this->ReportLines) ? $this->ReportLines : null;
    }
    /**
     * Set ReportLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfComparisonReportLine $reportLines
     * @return \Pcm\StructType\PcmLeastCostReport
     */
    public function setReportLines(\Pcm\ArrayType\PcmArrayOfComparisonReportLine $reportLines = null)
    {
        if (is_null($reportLines) || (is_array($reportLines) && empty($reportLines))) {
            unset($this->ReportLines);
        } else {
            $this->ReportLines = $reportLines;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmLeastCostReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
