<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeofenceIntersectRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GeofenceIntersectRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmGeofenceIntersectRequestBody extends AbstractStructBase
{
    /**
     * The fenceNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $fenceNames;
    /**
     * The intersectTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $intersectTime;
    /**
     * The setIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfint
     */
    public $setIds;
    /**
     * The setNames
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $setNames;
    /**
     * The setTags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfstring
     */
    public $setTags;
    /**
     * Constructor method for GeofenceIntersectRequestBody
     * @uses PcmGeofenceIntersectRequestBody::setFenceNames()
     * @uses PcmGeofenceIntersectRequestBody::setIntersectTime()
     * @uses PcmGeofenceIntersectRequestBody::setSetIds()
     * @uses PcmGeofenceIntersectRequestBody::setSetNames()
     * @uses PcmGeofenceIntersectRequestBody::setSetTags()
     * @param \Pcm\ArrayType\PcmArrayOfstring $fenceNames
     * @param string $intersectTime
     * @param \Pcm\ArrayType\PcmArrayOfint $setIds
     * @param \Pcm\ArrayType\PcmArrayOfstring $setNames
     * @param \Pcm\ArrayType\PcmArrayOfstring $setTags
     */
    public function __construct(\Pcm\ArrayType\PcmArrayOfstring $fenceNames = null, $intersectTime = null, \Pcm\ArrayType\PcmArrayOfint $setIds = null, \Pcm\ArrayType\PcmArrayOfstring $setNames = null, \Pcm\ArrayType\PcmArrayOfstring $setTags = null)
    {
        $this
            ->setFenceNames($fenceNames)
            ->setIntersectTime($intersectTime)
            ->setSetIds($setIds)
            ->setSetNames($setNames)
            ->setSetTags($setTags);
    }
    /**
     * Get fenceNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getFenceNames()
    {
        return isset($this->fenceNames) ? $this->fenceNames : null;
    }
    /**
     * Set fenceNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $fenceNames
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public function setFenceNames(\Pcm\ArrayType\PcmArrayOfstring $fenceNames = null)
    {
        if (is_null($fenceNames) || (is_array($fenceNames) && empty($fenceNames))) {
            unset($this->fenceNames);
        } else {
            $this->fenceNames = $fenceNames;
        }
        return $this;
    }
    /**
     * Get intersectTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntersectTime()
    {
        return isset($this->intersectTime) ? $this->intersectTime : null;
    }
    /**
     * Set intersectTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intersectTime
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public function setIntersectTime($intersectTime = null)
    {
        // validation for constraint: string
        if (!is_null($intersectTime) && !is_string($intersectTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intersectTime)), __LINE__);
        }
        if (is_null($intersectTime) || (is_array($intersectTime) && empty($intersectTime))) {
            unset($this->intersectTime);
        } else {
            $this->intersectTime = $intersectTime;
        }
        return $this;
    }
    /**
     * Get setIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfint|null
     */
    public function getSetIds()
    {
        return isset($this->setIds) ? $this->setIds : null;
    }
    /**
     * Set setIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfint $setIds
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public function setSetIds(\Pcm\ArrayType\PcmArrayOfint $setIds = null)
    {
        if (is_null($setIds) || (is_array($setIds) && empty($setIds))) {
            unset($this->setIds);
        } else {
            $this->setIds = $setIds;
        }
        return $this;
    }
    /**
     * Get setNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getSetNames()
    {
        return isset($this->setNames) ? $this->setNames : null;
    }
    /**
     * Set setNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $setNames
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public function setSetNames(\Pcm\ArrayType\PcmArrayOfstring $setNames = null)
    {
        if (is_null($setNames) || (is_array($setNames) && empty($setNames))) {
            unset($this->setNames);
        } else {
            $this->setNames = $setNames;
        }
        return $this;
    }
    /**
     * Get setTags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfstring|null
     */
    public function getSetTags()
    {
        return isset($this->setTags) ? $this->setTags : null;
    }
    /**
     * Set setTags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfstring $setTags
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public function setSetTags(\Pcm\ArrayType\PcmArrayOfstring $setTags = null)
    {
        if (is_null($setTags) || (is_array($setTags) && empty($setTags))) {
            unset($this->setTags);
        } else {
            $this->setTags = $setTags;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmGeofenceIntersectRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
