<?php

namespace Pcm\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETAOutOfRouteRequestBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ETAOutOfRouteRequestBody
 * @package Pcm
 * @subpackage Structs
 */
class PcmETAOutOfRouteRequestBody extends AbstractStructBase
{
    /**
     * The RouteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteID;
    /**
     * The Origin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmStopLocation
     */
    public $Origin;
    /**
     * The Destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmStopLocation
     */
    public $Destination;
    /**
     * The CurrentLocations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\ArrayType\PcmArrayOfStopLocation
     */
    public $CurrentLocations;
    /**
     * The RoutingOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmRouteOptions
     */
    public $RoutingOptions;
    /**
     * The ReportingOptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmReportOptions
     */
    public $ReportingOptions;
    /**
     * Constructor method for ETAOutOfRouteRequestBody
     * @uses PcmETAOutOfRouteRequestBody::setRouteID()
     * @uses PcmETAOutOfRouteRequestBody::setOrigin()
     * @uses PcmETAOutOfRouteRequestBody::setDestination()
     * @uses PcmETAOutOfRouteRequestBody::setCurrentLocations()
     * @uses PcmETAOutOfRouteRequestBody::setRoutingOptions()
     * @uses PcmETAOutOfRouteRequestBody::setReportingOptions()
     * @param string $routeID
     * @param \Pcm\StructType\PcmStopLocation $origin
     * @param \Pcm\StructType\PcmStopLocation $destination
     * @param \Pcm\ArrayType\PcmArrayOfStopLocation $currentLocations
     * @param \Pcm\StructType\PcmRouteOptions $routingOptions
     * @param \Pcm\StructType\PcmReportOptions $reportingOptions
     */
    public function __construct($routeID = null, \Pcm\StructType\PcmStopLocation $origin = null, \Pcm\StructType\PcmStopLocation $destination = null, \Pcm\ArrayType\PcmArrayOfStopLocation $currentLocations = null, \Pcm\StructType\PcmRouteOptions $routingOptions = null, \Pcm\StructType\PcmReportOptions $reportingOptions = null)
    {
        $this
            ->setRouteID($routeID)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setCurrentLocations($currentLocations)
            ->setRoutingOptions($routingOptions)
            ->setReportingOptions($reportingOptions);
    }
    /**
     * Get RouteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteID()
    {
        return isset($this->RouteID) ? $this->RouteID : null;
    }
    /**
     * Set RouteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeID
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setRouteID($routeID = null)
    {
        // validation for constraint: string
        if (!is_null($routeID) && !is_string($routeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeID)), __LINE__);
        }
        if (is_null($routeID) || (is_array($routeID) && empty($routeID))) {
            unset($this->RouteID);
        } else {
            $this->RouteID = $routeID;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmStopLocation $origin
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setOrigin(\Pcm\StructType\PcmStopLocation $origin = null)
    {
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmStopLocation|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmStopLocation $destination
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setDestination(\Pcm\StructType\PcmStopLocation $destination = null)
    {
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get CurrentLocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\ArrayType\PcmArrayOfStopLocation|null
     */
    public function getCurrentLocations()
    {
        return isset($this->CurrentLocations) ? $this->CurrentLocations : null;
    }
    /**
     * Set CurrentLocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\ArrayType\PcmArrayOfStopLocation $currentLocations
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setCurrentLocations(\Pcm\ArrayType\PcmArrayOfStopLocation $currentLocations = null)
    {
        if (is_null($currentLocations) || (is_array($currentLocations) && empty($currentLocations))) {
            unset($this->CurrentLocations);
        } else {
            $this->CurrentLocations = $currentLocations;
        }
        return $this;
    }
    /**
     * Get RoutingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmRouteOptions|null
     */
    public function getRoutingOptions()
    {
        return isset($this->RoutingOptions) ? $this->RoutingOptions : null;
    }
    /**
     * Set RoutingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmRouteOptions $routingOptions
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setRoutingOptions(\Pcm\StructType\PcmRouteOptions $routingOptions = null)
    {
        if (is_null($routingOptions) || (is_array($routingOptions) && empty($routingOptions))) {
            unset($this->RoutingOptions);
        } else {
            $this->RoutingOptions = $routingOptions;
        }
        return $this;
    }
    /**
     * Get ReportingOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmReportOptions|null
     */
    public function getReportingOptions()
    {
        return isset($this->ReportingOptions) ? $this->ReportingOptions : null;
    }
    /**
     * Set ReportingOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Pcm\StructType\PcmReportOptions $reportingOptions
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public function setReportingOptions(\Pcm\StructType\PcmReportOptions $reportingOptions = null)
    {
        if (is_null($reportingOptions) || (is_array($reportingOptions) && empty($reportingOptions))) {
            unset($this->ReportingOptions);
        } else {
            $this->ReportingOptions = $reportingOptions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\StructType\PcmETAOutOfRouteRequestBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
