<?php

namespace Pcm\EnumType;

/**
 * This class stands for StopType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StopType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmStopType
{
    /**
     * Constant for value 'Origin'
     * @return string 'Origin'
     */
    const VALUE_ORIGIN = 'Origin';
    /**
     * Constant for value 'Work'
     * @return string 'Work'
     */
    const VALUE_WORK = 'Work';
    /**
     * Constant for value 'Waypoint'
     * @return string 'Waypoint'
     */
    const VALUE_WAYPOINT = 'Waypoint';
    /**
     * Constant for value 'FuelStop'
     * @return string 'FuelStop'
     */
    const VALUE_FUEL_STOP = 'FuelStop';
    /**
     * Constant for value 'RestStopShort'
     * @return string 'RestStopShort'
     */
    const VALUE_REST_STOP_SHORT = 'RestStopShort';
    /**
     * Constant for value 'RestStopLong'
     * @return string 'RestStopLong'
     */
    const VALUE_REST_STOP_LONG = 'RestStopLong';
    /**
     * Constant for value 'RestStopCycleReset'
     * @return string 'RestStopCycleReset'
     */
    const VALUE_REST_STOP_CYCLE_RESET = 'RestStopCycleReset';
    /**
     * Constant for value 'Destination'
     * @return string 'Destination'
     */
    const VALUE_DESTINATION = 'Destination';
    /**
     * Constant for value 'Delivery'
     * @return string 'Delivery'
     */
    const VALUE_DELIVERY = 'Delivery';
    /**
     * Constant for value 'Pickup'
     * @return string 'Pickup'
     */
    const VALUE_PICKUP = 'Pickup';
    /**
     * Constant for value 'RendezVous'
     * @return string 'RendezVous'
     */
    const VALUE_RENDEZ_VOUS = 'RendezVous';
    /**
     * Constant for value 'RestStopFullDay'
     * @return string 'RestStopFullDay'
     */
    const VALUE_REST_STOP_FULL_DAY = 'RestStopFullDay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGIN
     * @uses self::VALUE_WORK
     * @uses self::VALUE_WAYPOINT
     * @uses self::VALUE_FUEL_STOP
     * @uses self::VALUE_REST_STOP_SHORT
     * @uses self::VALUE_REST_STOP_LONG
     * @uses self::VALUE_REST_STOP_CYCLE_RESET
     * @uses self::VALUE_DESTINATION
     * @uses self::VALUE_DELIVERY
     * @uses self::VALUE_PICKUP
     * @uses self::VALUE_RENDEZ_VOUS
     * @uses self::VALUE_REST_STOP_FULL_DAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGIN,
            self::VALUE_WORK,
            self::VALUE_WAYPOINT,
            self::VALUE_FUEL_STOP,
            self::VALUE_REST_STOP_SHORT,
            self::VALUE_REST_STOP_LONG,
            self::VALUE_REST_STOP_CYCLE_RESET,
            self::VALUE_DESTINATION,
            self::VALUE_DELIVERY,
            self::VALUE_PICKUP,
            self::VALUE_RENDEZ_VOUS,
            self::VALUE_REST_STOP_FULL_DAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
