<?php

namespace Pcm\EnumType;

/**
 * This class stands for SpeedLimitType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SpeedLimitType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmSpeedLimitType
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Historic'
     * @return string 'Historic'
     */
    const VALUE_HISTORIC = 'Historic';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Constant for value 'Navteq'
     * @return string 'Navteq'
     */
    const VALUE_NAVTEQ = 'Navteq';
    /**
     * Constant for value 'LinkBased'
     * @return string 'LinkBased'
     */
    const VALUE_LINK_BASED = 'LinkBased';
    /**
     * Constant for value 'JWR'
     * @return string 'JWR'
     */
    const VALUE_JWR = 'JWR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_HISTORIC
     * @uses self::VALUE_PREMIUM
     * @uses self::VALUE_NAVTEQ
     * @uses self::VALUE_LINK_BASED
     * @uses self::VALUE_JWR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_HISTORIC,
            self::VALUE_PREMIUM,
            self::VALUE_NAVTEQ,
            self::VALUE_LINK_BASED,
            self::VALUE_JWR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
