<?php

namespace Pcm\EnumType;

/**
 * This class stands for RouteOptimizeType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteOptimizeType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmRouteOptimizeType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'ThruAll'
     * @return string 'ThruAll'
     */
    const VALUE_THRU_ALL = 'ThruAll';
    /**
     * Constant for value 'DestinationFixed'
     * @return string 'DestinationFixed'
     */
    const VALUE_DESTINATION_FIXED = 'DestinationFixed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_THRU_ALL
     * @uses self::VALUE_DESTINATION_FIXED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_THRU_ALL,
            self::VALUE_DESTINATION_FIXED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
