<?php

namespace Pcm\EnumType;

/**
 * This class stands for POIGenericType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:POIGenericType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmPOIGenericType
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'WeightStation'
     * @return string 'WeightStation'
     */
    const VALUE_WEIGHT_STATION = 'WeightStation';
    /**
     * Constant for value 'CatScale'
     * @return string 'CatScale'
     */
    const VALUE_CAT_SCALE = 'CatScale';
    /**
     * Constant for value 'LCVLot'
     * @return string 'LCVLot'
     */
    const VALUE_LCVLOT = 'LCVLot';
    /**
     * Constant for value 'Hotel'
     * @return string 'Hotel'
     */
    const VALUE_HOTEL = 'Hotel';
    /**
     * Constant for value 'IntermodalRamp'
     * @return string 'IntermodalRamp'
     */
    const VALUE_INTERMODAL_RAMP = 'IntermodalRamp';
    /**
     * Constant for value 'Parking'
     * @return string 'Parking'
     */
    const VALUE_PARKING = 'Parking';
    /**
     * Constant for value 'RestAreaHoS'
     * @return string 'RestAreaHoS'
     */
    const VALUE_REST_AREA_HO_S = 'RestAreaHoS';
    /**
     * Constant for value 'TruckStop'
     * @return string 'TruckStop'
     */
    const VALUE_TRUCK_STOP = 'TruckStop';
    /**
     * Constant for value 'TruckServiceHoS'
     * @return string 'TruckServiceHoS'
     */
    const VALUE_TRUCK_SERVICE_HO_S = 'TruckServiceHoS';
    /**
     * Constant for value 'HighwayExit'
     * @return string 'HighwayExit'
     */
    const VALUE_HIGHWAY_EXIT = 'HighwayExit';
    /**
     * Constant for value 'MajorAirport'
     * @return string 'MajorAirport'
     */
    const VALUE_MAJOR_AIRPORT = 'MajorAirport';
    /**
     * Constant for value 'EventFacility'
     * @return string 'EventFacility'
     */
    const VALUE_EVENT_FACILITY = 'EventFacility';
    /**
     * Constant for value 'DistributionCenter'
     * @return string 'DistributionCenter'
     */
    const VALUE_DISTRIBUTION_CENTER = 'DistributionCenter';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_WEIGHT_STATION
     * @uses self::VALUE_CAT_SCALE
     * @uses self::VALUE_LCVLOT
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_INTERMODAL_RAMP
     * @uses self::VALUE_PARKING
     * @uses self::VALUE_REST_AREA_HO_S
     * @uses self::VALUE_TRUCK_STOP
     * @uses self::VALUE_TRUCK_SERVICE_HO_S
     * @uses self::VALUE_HIGHWAY_EXIT
     * @uses self::VALUE_MAJOR_AIRPORT
     * @uses self::VALUE_EVENT_FACILITY
     * @uses self::VALUE_DISTRIBUTION_CENTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_WEIGHT_STATION,
            self::VALUE_CAT_SCALE,
            self::VALUE_LCVLOT,
            self::VALUE_HOTEL,
            self::VALUE_INTERMODAL_RAMP,
            self::VALUE_PARKING,
            self::VALUE_REST_AREA_HO_S,
            self::VALUE_TRUCK_STOP,
            self::VALUE_TRUCK_SERVICE_HO_S,
            self::VALUE_HIGHWAY_EXIT,
            self::VALUE_MAJOR_AIRPORT,
            self::VALUE_EVENT_FACILITY,
            self::VALUE_DISTRIBUTION_CENTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
