<?php

namespace Pcm\EnumType;

/**
 * This class stands for LanguageType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LanguageType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmLanguageType
{
    /**
     * Constant for value 'ENUS'
     * @return string 'ENUS'
     */
    const VALUE_ENUS = 'ENUS';
    /**
     * Constant for value 'ENGB'
     * @return string 'ENGB'
     */
    const VALUE_ENGB = 'ENGB';
    /**
     * Constant for value 'DE'
     * @return string 'DE'
     */
    const VALUE_DE = 'DE';
    /**
     * Constant for value 'FR'
     * @return string 'FR'
     */
    const VALUE_FR = 'FR';
    /**
     * Constant for value 'ES'
     * @return string 'ES'
     */
    const VALUE_ES = 'ES';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ENUS
     * @uses self::VALUE_ENGB
     * @uses self::VALUE_DE
     * @uses self::VALUE_FR
     * @uses self::VALUE_ES
     * @uses self::VALUE_IT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ENUS,
            self::VALUE_ENGB,
            self::VALUE_DE,
            self::VALUE_FR,
            self::VALUE_ES,
            self::VALUE_IT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
