<?php

namespace Pcm\EnumType;

/**
 * This class stands for ClassOverrideType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClassOverrideType
 * @package Pcm
 * @subpackage Enumerations
 */
class PcmClassOverrideType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'FiftyThreeFoot'
     * @return string 'FiftyThreeFoot'
     */
    const VALUE_FIFTY_THREE_FOOT = 'FiftyThreeFoot';
    /**
     * Constant for value 'NationalNetwork'
     * @return string 'NationalNetwork'
     */
    const VALUE_NATIONAL_NETWORK = 'NationalNetwork';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_FIFTY_THREE_FOOT
     * @uses self::VALUE_NATIONAL_NETWORK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_FIFTY_THREE_FOOT,
            self::VALUE_NATIONAL_NETWORK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
