<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReportRoute ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReportRoute
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfReportRoute extends AbstractStructArrayBase
{
    /**
     * The ReportRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Pcm\StructType\PcmReportRoute[]
     */
    public $ReportRoute;
    /**
     * Constructor method for ArrayOfReportRoute
     * @uses PcmArrayOfReportRoute::setReportRoute()
     * @param \Pcm\StructType\PcmReportRoute[] $reportRoute
     */
    public function __construct(array $reportRoute = array())
    {
        $this
            ->setReportRoute($reportRoute);
    }
    /**
     * Get ReportRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Pcm\StructType\PcmReportRoute[]|null
     */
    public function getReportRoute()
    {
        return isset($this->ReportRoute) ? $this->ReportRoute : null;
    }
    /**
     * Set ReportRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmReportRoute[] $reportRoute
     * @return \Pcm\ArrayType\PcmArrayOfReportRoute
     */
    public function setReportRoute(array $reportRoute = array())
    {
        foreach ($reportRoute as $arrayOfReportRouteReportRouteItem) {
            // validation for constraint: itemType
            if (!$arrayOfReportRouteReportRouteItem instanceof \Pcm\StructType\PcmReportRoute) {
                throw new \InvalidArgumentException(sprintf('The ReportRoute property can only contain items of \Pcm\StructType\PcmReportRoute, "%s" given', is_object($arrayOfReportRouteReportRouteItem) ? get_class($arrayOfReportRouteReportRouteItem) : gettype($arrayOfReportRouteReportRouteItem)), __LINE__);
            }
        }
        if (is_null($reportRoute) || (is_array($reportRoute) && empty($reportRoute))) {
            unset($this->ReportRoute);
        } else {
            $this->ReportRoute = $reportRoute;
        }
        return $this;
    }
    /**
     * Add item to ReportRoute value
     * @throws \InvalidArgumentException
     * @param \Pcm\StructType\PcmReportRoute $item
     * @return \Pcm\ArrayType\PcmArrayOfReportRoute
     */
    public function addToReportRoute(\Pcm\StructType\PcmReportRoute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Pcm\StructType\PcmReportRoute) {
            throw new \InvalidArgumentException(sprintf('The ReportRoute property can only contain items of \Pcm\StructType\PcmReportRoute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReportRoute[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Pcm\StructType\PcmReportRoute|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Pcm\StructType\PcmReportRoute|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Pcm\StructType\PcmReportRoute|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Pcm\StructType\PcmReportRoute|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Pcm\StructType\PcmReportRoute|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReportRoute
     */
    public function getAttributeName()
    {
        return 'ReportRoute';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfReportRoute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
