<?php

namespace Pcm\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPOIHosType ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPOIHosType
 * @package Pcm
 * @subpackage Arrays
 */
class PcmArrayOfPOIHosType extends AbstractStructArrayBase
{
    /**
     * The POIHosType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $POIHosType;
    /**
     * Constructor method for ArrayOfPOIHosType
     * @uses PcmArrayOfPOIHosType::setPOIHosType()
     * @param string[] $pOIHosType
     */
    public function __construct(array $pOIHosType = array())
    {
        $this
            ->setPOIHosType($pOIHosType);
    }
    /**
     * Get POIHosType value
     * @return string[]|null
     */
    public function getPOIHosType()
    {
        return $this->POIHosType;
    }
    /**
     * Set POIHosType value
     * @uses \Pcm\EnumType\PcmPOIHosType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPOIHosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $pOIHosType
     * @return \Pcm\ArrayType\PcmArrayOfPOIHosType
     */
    public function setPOIHosType(array $pOIHosType = array())
    {
        $invalidValues = array();
        foreach ($pOIHosType as $arrayOfPOIHosTypePOIHosTypeItem) {
            if (!\Pcm\EnumType\PcmPOIHosType::valueIsValid($arrayOfPOIHosTypePOIHosTypeItem)) {
                $invalidValues[] = var_export($arrayOfPOIHosTypePOIHosTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \Pcm\EnumType\PcmPOIHosType::getValidValues())), __LINE__);
        }
        $this->POIHosType = $pOIHosType;
        return $this;
    }
    /**
     * Add item to POIHosType value
     * @uses \Pcm\EnumType\PcmPOIHosType::valueIsValid()
     * @uses \Pcm\EnumType\PcmPOIHosType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfPOIHosType
     */
    public function addToPOIHosType($item)
    {
        // validation for constraint: enumeration
        if (!\Pcm\EnumType\PcmPOIHosType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmPOIHosType::getValidValues())), __LINE__);
        }
        $this->POIHosType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \Pcm\EnumType\PcmPOIHosType::valueIsValid()
     * @param string $item
     * @return \Pcm\ArrayType\PcmArrayOfPOIHosType
     */
    public function add($item)
    {
        if (!\Pcm\EnumType\PcmPOIHosType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Pcm\EnumType\PcmPOIHosType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string POIHosType
     */
    public function getAttributeName()
    {
        return 'POIHosType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Pcm\ArrayType\PcmArrayOfPOIHosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
